/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles.profile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nethanialchorus.profiles.network.ProfileNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class CharacterProfile {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"characterprofiles");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<CharacterProfile>> PROFILE = ATTACHMENT_TYPES.register("character_profile", () -> AttachmentType.builder(() -> null).serialize(CODEC).copyOnDeath().build());
    public static final Codec<CharacterProfile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("playerUUID").forGetter(CharacterProfile::getPlayerUUID), (App)Codec.STRING.fieldOf("name").forGetter(CharacterProfile::getName), (App)Codec.INT.fieldOf("age").forGetter(CharacterProfile::getAge), (App)Codec.STRING.fieldOf("description").forGetter(CharacterProfile::getDescription), (App)Codec.STRING.optionalFieldOf("characterClass", (Object)"").forGetter(CharacterProfile::getCharacterClass), (App)Codec.STRING.listOf().optionalFieldOf("traits", new ArrayList()).forGetter(CharacterProfile::getTraits), (App)Codec.BOOL.optionalFieldOf("nameVisible", (Object)true).forGetter(CharacterProfile::isNameVisible), (App)Codec.BOOL.optionalFieldOf("ageVisible", (Object)true).forGetter(CharacterProfile::isAgeVisible), (App)Codec.BOOL.optionalFieldOf("descriptionVisible", (Object)true).forGetter(CharacterProfile::isDescriptionVisible), (App)Codec.BOOL.optionalFieldOf("classVisible", (Object)true).forGetter(CharacterProfile::isClassVisible), (App)Codec.BOOL.optionalFieldOf("traitsVisible", (Object)true).forGetter(CharacterProfile::isTraitsVisible)).apply((Applicative)instance, CharacterProfile::new));
    private String name;
    private int age;
    private String description;
    private String characterClass;
    private List<String> traits;
    private UUID playerUUID;
    private boolean nameVisible;
    private boolean ageVisible;
    private boolean descriptionVisible;
    private boolean classVisible;
    private boolean traitsVisible;

    public CharacterProfile(UUID playerUUID, String name, int age, String description, String characterClass, List<String> traits, boolean nameVisible, boolean ageVisible, boolean descriptionVisible, boolean classVisible, boolean traitsVisible) {
        this.playerUUID = playerUUID;
        this.name = name;
        this.age = age;
        this.description = description;
        this.characterClass = characterClass;
        this.traits = new ArrayList<String>(traits);
        this.nameVisible = nameVisible;
        this.ageVisible = ageVisible;
        this.descriptionVisible = descriptionVisible;
        this.classVisible = classVisible;
        this.traitsVisible = traitsVisible;
    }

    public CharacterProfile(UUID playerUUID, String name, int age, String description, String characterClass, List<String> traits) {
        this(playerUUID, name, age, description, characterClass, traits, true, true, true, true, true);
    }

    public CharacterProfile(UUID playerUUID, String name, int age, String description) {
        this(playerUUID, name, age, description, "", new ArrayList<String>());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCharacterClass() {
        return this.characterClass;
    }

    public void setCharacterClass(String characterClass) {
        this.characterClass = characterClass;
    }

    public List<String> getTraits() {
        return this.traits;
    }

    public void setTraits(List<String> traits) {
        this.traits = new ArrayList<String>(traits);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean nameVisible) {
        this.nameVisible = nameVisible;
    }

    public boolean isAgeVisible() {
        return this.ageVisible;
    }

    public void setAgeVisible(boolean ageVisible) {
        this.ageVisible = ageVisible;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionVisible;
    }

    public void setDescriptionVisible(boolean descriptionVisible) {
        this.descriptionVisible = descriptionVisible;
    }

    public boolean isClassVisible() {
        return this.classVisible;
    }

    public void setClassVisible(boolean classVisible) {
        this.classVisible = classVisible;
    }

    public boolean isTraitsVisible() {
        return this.traitsVisible;
    }

    public void setTraitsVisible(boolean traitsVisible) {
        this.traitsVisible = traitsVisible;
    }

    public static Optional<CharacterProfile> getProfile(ServerPlayer player) {
        return Optional.ofNullable((CharacterProfile)player.getData(PROFILE));
    }

    public static void setProfile(ServerPlayer player, CharacterProfile profile) {
        player.setData(PROFILE, (Object)profile);
        CharacterProfile.syncToSelf(player);
    }

    public static boolean hasProfile(ServerPlayer player) {
        return player.getData(PROFILE) != null;
    }

    public static void removeProfile(ServerPlayer player) {
        player.removeData(PROFILE);
        CharacterProfile.syncToSelf(player);
    }

    public static void syncToSelf(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile profile = (CharacterProfile)player.getData(PROFILE);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ProfileNetworkHandler.SyncProfilePacket(profile), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected static void syncTo(ServerPlayer player, CharacterProfile profile) {
        if (player.level().isClientSide) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ProfileNetworkHandler.SyncProfilePacket(profile), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void entityJoinLevel(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static void playerJoinWorld(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static void playerChangedDimension(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static void playerStartTracking(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static void playerDeath(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static void playerClone(boolean isWasDeath, ServerPlayer player, ServerPlayer oldPlayer) {
        if (!isWasDeath) {
            return;
        }
        CharacterProfile.syncToSelf(player);
    }

    public static Optional<CharacterProfile> getProfileByUUID(ServerPlayer requester, UUID targetUUID) {
        ServerPlayer targetPlayer = requester.server.getPlayerList().getPlayer(targetUUID);
        if (targetPlayer != null) {
            return CharacterProfile.getProfile(targetPlayer);
        }
        return Optional.empty();
    }

    public static Optional<CharacterProfile> getProfile(ServerPlayer requester, ServerPlayer target) {
        return CharacterProfile.getProfile(target);
    }

    public CharacterProfile createFilteredProfile(boolean isOwnProfile) {
        if (isOwnProfile) {
            return this;
        }
        CharacterProfile filtered = new CharacterProfile(this.playerUUID, this.nameVisible ? this.name : "[Hidden]", this.ageVisible ? this.age : 0, this.descriptionVisible ? this.description : "[Hidden]", this.classVisible ? this.characterClass : "[Hidden]", this.traitsVisible ? new ArrayList<String>(this.traits) : new ArrayList(), this.nameVisible, this.ageVisible, this.descriptionVisible, this.classVisible, this.traitsVisible);
        return filtered;
    }
}

