/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.AbstractOnlineSoundInstance;
import gg.moonflower.etched.api.sound.OnlineRecordSoundInstance;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.block.RadioBlock;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.core.mixin.client.gui.GuiAccessor;
import gg.moonflower.etched.core.mixin.client.render.LevelRendererAccessor;
import gg.moonflower.etched.core.registry.EtchedTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class SoundTracker {
    private static final Int2ObjectArrayMap<SoundInstance> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();
    private static final Set<String> FAILED_URLS = new HashSet<String>();
    private static final Component RADIO = Component.translatable((String)"sound_source.etched.radio");

    private static synchronized void setRecordPlayingNearby(CommonLevelAccessor level, BlockPos pos, boolean playing) {
        if (level.getBlockState(pos).is(EtchedTags.RECORD_PLAYERS)) {
            for (LivingEntity livingEntity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(3.0))) {
                livingEntity.setRecordPlayingNearby(pos, playing);
            }
        }
    }

    @Nullable
    public static SoundInstance getEntitySound(int entity) {
        return (SoundInstance)ENTITY_PLAYING_SOUNDS.get(entity);
    }

    public static void setEntitySound(int entity, @Nullable SoundInstance instance) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        if (instance == null) {
            SoundInstance old = (SoundInstance)ENTITY_PLAYING_SOUNDS.remove(entity);
            if (old != null) {
                if (old instanceof StopListeningSound) {
                    ((StopListeningSound)old).stopListening();
                }
                soundManager.stop(old);
            }
        } else {
            ENTITY_PLAYING_SOUNDS.put(entity, (Object)instance);
            soundManager.play(instance);
        }
    }

    @Nullable
    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final Component title, final Entity entity, int attenuationDistance, boolean stream) {
        if (!TrackData.isValidURL(url) || FAILED_URLS.contains(url)) {
            return null;
        }
        BlockState aboveState = entity.level().getBlockState(entity.blockPosition().above());
        boolean muffled = aboveState.is(BlockTags.WOOL);
        final boolean hidden = !aboveState.isAir();
        return new OnlineRecordSoundInstance(url, entity, muffled ? 2.0f : 4.0f, muffled ? attenuationDistance / 2 : attenuationDistance, new MusicDownloadListener(title, () -> ((Entity)entity).getX(), () -> ((Entity)entity).getY(), () -> ((Entity)entity).getZ()){

            @Override
            public void onSuccess() {
                if (!entity.isAlive() || !ENTITY_PLAYING_SOUNDS.containsKey(entity.getId())) {
                    this.clearComponent();
                } else if (!hidden && PlayableRecord.canShowMessage(entity.getX(), entity.getY(), entity.getZ())) {
                    Minecraft.getInstance().gui.setNowPlaying(title);
                }
            }

            @Override
            public void onFail() {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, stream ? AudioSource.AudioFileType.STREAM : AudioSource.AudioFileType.FILE);
    }

    @Nullable
    public static AbstractOnlineSoundInstance getEtchedRecord(String url, Component title, Entity entity, boolean stream) {
        return SoundTracker.getEtchedRecord(url, title, entity, 16, stream);
    }

    @Nullable
    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final Component title, final CommonLevelAccessor level, final BlockPos pos, int attenuationDistance, AudioSource.AudioFileType type) {
        if (!TrackData.isValidURL(url) || FAILED_URLS.contains(url)) {
            return null;
        }
        BlockState aboveState = level.getBlockState(pos.above());
        boolean muffled = aboveState.is(BlockTags.WOOL);
        final boolean hidden = !aboveState.isAir();
        final Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getPlayingJukeboxSongs();
        return new OnlineRecordSoundInstance(url, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, muffled ? 2.0f : 4.0f, muffled ? attenuationDistance / 2 : attenuationDistance, new MusicDownloadListener(title, () -> (double)pos.getX() + 0.5, () -> (double)pos.getY() + 0.5, () -> (double)pos.getZ() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (!hidden && PlayableRecord.canShowMessage((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)) {
                        Minecraft.getInstance().gui.setNowPlaying(title);
                    }
                    SoundTracker.setRecordPlayingNearby(level, pos, true);
                }
            }

            @Override
            public void onFail() {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, type);
    }

    @Nullable
    public static AbstractOnlineSoundInstance getEtchedRecord(String url, Component title, CommonLevelAccessor level, BlockPos pos, AudioSource.AudioFileType type) {
        return SoundTracker.getEtchedRecord(url, title, level, pos, 16, type);
    }

    private static void playRecord(BlockPos pos, SoundInstance sound) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getPlayingJukeboxSongs();
        playingRecords.put(pos, sound);
        soundManager.play(sound);
    }

    private static void playNextRecord(CommonLevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        SoundTracker.playAlbum(jukebox, blockEntity.getBlockState(), level, pos, true);
    }

    public static void playBlockRecord(BlockPos pos, TrackData[] tracks, int track) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        if (track >= tracks.length) {
            SoundTracker.setRecordPlayingNearby((CommonLevelAccessor)level, pos, false);
            return;
        }
        TrackData trackData = tracks[track];
        String url = trackData.url();
        if (!TrackData.isValidURL(url) || FAILED_URLS.contains(url)) {
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
            return;
        }
        SoundTracker.playRecord(pos, StopListeningSound.create((SoundInstance)SoundTracker.getEtchedRecord(url, trackData.getDisplayName(), (CommonLevelAccessor)level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.getInstance().tell(() -> {
            if (!((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getPlayingJukeboxSongs().containsKey(pos)) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
        })));
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, int attenuationDistance, boolean loop) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(entityId);
        if (entity == null) {
            return;
        }
        Optional<SoundInstance> sound = PlayableRecord.createEntitySound(record, entity, track, attenuationDistance);
        if (sound.isEmpty()) {
            if (loop && track != 0) {
                SoundTracker.playEntityRecord(record, entityId, 0, attenuationDistance, true);
            }
            return;
        }
        SoundInstance entitySound = (SoundInstance)ENTITY_PLAYING_SOUNDS.remove(entity.getId());
        if (entitySound != null) {
            if (entitySound instanceof StopListeningSound) {
                ((StopListeningSound)entitySound).stopListening();
            }
            Minecraft.getInstance().getSoundManager().stop(entitySound);
        }
        entitySound = StopListeningSound.create(sound.get(), () -> Minecraft.getInstance().tell(() -> {
            ENTITY_PLAYING_SOUNDS.remove(entityId);
            SoundTracker.playEntityRecord(record, entityId, track + 1, attenuationDistance, loop);
        }));
        ENTITY_PLAYING_SOUNDS.put(entityId, (Object)entitySound);
        Minecraft.getInstance().getSoundManager().play(entitySound);
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, boolean loop) {
        SoundTracker.playEntityRecord(record, entityId, track, 16, loop);
    }

    public static void playBoombox(int entityId, ItemStack record) {
        SoundTracker.setEntitySound(entityId, null);
        if (!record.isEmpty()) {
            SoundTracker.playEntityRecord(record, entityId, 0, 8, true);
        }
    }

    public static void playRadio(@Nullable String url, BlockState state, CommonLevelAccessor level, BlockPos pos) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getPlayingJukeboxSongs();
        SoundInstance soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.stop(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby(level, pos, false);
        }
        if (FAILED_URLS.contains(url)) {
            return;
        }
        if (!state.hasProperty((Property)RadioBlock.POWERED) || ((Boolean)state.getValue((Property)RadioBlock.POWERED)).booleanValue()) {
            return;
        }
        if (TrackData.isValidURL(url)) {
            AbstractOnlineSoundInstance record = SoundTracker.getEtchedRecord(url, RADIO, level, pos, 8, AudioSource.AudioFileType.BOTH);
            record.setLoop(true);
            SoundTracker.playRecord(pos, (SoundInstance)record);
        }
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, BlockState state, CommonLevelAccessor level, BlockPos pos, boolean force) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getPlayingJukeboxSongs();
        if (!state.hasProperty((Property)AlbumJukeboxBlock.POWERED) || !((Boolean)state.getValue((Property)AlbumJukeboxBlock.POWERED)).booleanValue() && !force && !jukebox.recalculatePlayingIndex(false)) {
            return;
        }
        SoundInstance soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.stop(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby(level, pos, false);
        }
        if (((Boolean)state.getValue((Property)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        ItemStack disc = jukebox.getItem(jukebox.getPlayingIndex());
        int trackCount = PlayableRecord.getTrackCount((HolderLookup.Provider)level.registryAccess(), disc);
        int track = jukebox.getTrack() < 0 || jukebox.getTrack() >= trackCount ? 0 : jukebox.getTrack();
        PlayableRecord.createBlockSound(disc, level, pos, track).ifPresent(sound -> {
            SoundTracker.playRecord(pos, StopListeningSound.create(sound, () -> Minecraft.getInstance().tell(() -> SoundTracker.playNextRecord(level, pos))));
            SoundTracker.setRecordPlayingNearby(level, pos, true);
        });
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> FAILED_URLS.clear());
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final Component title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private final BlockPos.MutableBlockPos pos;
        private float size;
        private Component requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(Component title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
            this.pos = new BlockPos.MutableBlockPos();
        }

        private BlockPos.MutableBlockPos getPos() {
            return this.pos.set(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble());
        }

        private void setComponent(Component text) {
            if (!(this.component != null || Minecraft.getInstance().level != null && Minecraft.getInstance().level.getBlockState((BlockPos)this.getPos().move(Direction.UP)).isAir() && PlayableRecord.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble()))) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                Minecraft.getInstance().gui.setOverlayMessage((Component)this.component, true);
                ((GuiAccessor)Minecraft.getInstance().gui).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (((GuiAccessor)Minecraft.getInstance().gui).getOverlayMessageString() == this.component) {
                ((GuiAccessor)Minecraft.getInstance().gui).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(Component component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((Component)this.requesting.copy().append(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((Component)Component.translatable((String)"record.etched.downloadProgress", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((Component)Component.translatable((String)"record.etched.loading", (Object[])new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"record.etched.downloadFail", (Object[])new Object[]{this.title}), true);
        }
    }

    private static class DownloadTextComponent
    implements Component {
        private ComponentContents contents = PlainTextContents.EMPTY;
        private FormattedCharSequence visualOrderText = FormattedCharSequence.EMPTY;
        private Language decomposedWith = null;

        public ComponentContents getContents() {
            return this.contents;
        }

        public List<Component> getSiblings() {
            return Collections.emptyList();
        }

        public Style getStyle() {
            return Style.EMPTY;
        }

        public FormattedCharSequence getVisualOrderText() {
            Language language = Language.getInstance();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.getVisualOrder((FormattedText)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownloadTextComponent that = (DownloadTextComponent)o;
            return this.contents.equals((Object)that.contents);
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public String toString() {
            return this.contents.toString();
        }

        public void setText(String text) {
            this.contents = new PlainTextContents.LiteralContents(text);
            this.decomposedWith = null;
        }
    }
}

