/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.block;

import com.mojang.serialization.MapCodec;
import gg.moonflower.etched.common.blockentity.RadioBlockEntity;
import gg.moonflower.etched.common.menu.RadioMenu;
import gg.moonflower.etched.core.mixin.client.render.LevelRendererAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RadioBlock
extends BaseEntityBlock {
    public static final MapCodec<RadioBlock> CODEC = RadioBlock.simpleCodec(RadioBlock::new);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty PORTAL = BooleanProperty.create((String)"portal");
    private static final VoxelShape X_SHAPE = Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)8.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)8.0, (double)11.0);
    private static final VoxelShape ROTATED_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.etched.radio");

    public RadioBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)PORTAL, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        MenuProvider menuProvider;
        if (stack.is(Items.CAKE) && !((Boolean)state.getValue((Property)PORTAL)).booleanValue()) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)PORTAL, (Comparable)Boolean.valueOf(true)), 3);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!level.isClientSide() && (menuProvider = state.getMenuProvider(level, pos)) != null) {
            String string;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RadioBlockEntity) {
                RadioBlockEntity be = (RadioBlockEntity)blockEntity;
                string = be.getUrl();
            } else {
                string = null;
            }
            String url = string;
            player.openMenu(menuProvider, buf -> buf.writeUtf(url != null ? url : ""));
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(Mth.floor((double)((double)((180.0f + context.getRotation()) * 16.0f / 360.0f) + 0.5)) & 0xF))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.isClientSide() && ((Boolean)state.getValue((Property)POWERED)).booleanValue() != level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RadioBlockEntity) {
                RadioBlockEntity radio = (RadioBlockEntity)blockEntity;
                if (radio.isPlaying()) {
                    level.levelEvent(1011, pos, 0);
                }
                Clearable.tryClear((Object)blockEntity);
            }
            super.onRemove(state, level, pos, newState, moving);
        }
    }

    public MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((menuId, playerInventory, player) -> new RadioMenu(menuId, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos)), CONTAINER_TITLE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        int rotation = (Integer)state.getValue((Property)ROTATION);
        if (rotation % 8 == 0) {
            return Z_SHAPE;
        }
        if (rotation % 8 == 4) {
            return X_SHAPE;
        }
        return ROTATED_SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState blockState) {
        return true;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RadioBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION, POWERED, PORTAL});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((Boolean)state.getValue((Property)PORTAL) != false ? (ItemLike)EtchedBlocks.PORTAL_RADIO_ITEM.get() : (ItemLike)EtchedBlocks.RADIO.get());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.getBlockState(pos.above()).isAir()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RadioBlockEntity)) {
            return;
        }
        RadioBlockEntity radio = (RadioBlockEntity)blockEntity;
        if (radio.getUrl() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Map<BlockPos, SoundInstance> sounds = ((LevelRendererAccessor)minecraft.levelRenderer).getPlayingJukeboxSongs();
        if (sounds.containsKey(pos) && minecraft.getSoundManager().isActive(sounds.get(pos))) {
            level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, (double)random.nextInt(25) / 24.0, 0.0, 0.0);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide()) {
            return null;
        }
        return RadioBlock.createTickerHelper(blockEntityType, EtchedBlocks.RADIO_BE.get(), RadioBlockEntity::tickClient);
    }
}

