/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record MusicLabelComponent(String artist, String title, int primaryColor, int secondaryColor) implements TooltipProvider
{
    private final int primaryColor;
    private final int secondaryColor;
    public static final MusicLabelComponent DEFAULT = new MusicLabelComponent("", "Custom Music", -1, -1);
    private static final Codec<MusicLabelComponent> COMPLEX_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("author").forGetter(MusicLabelComponent::artist), (App)Codec.STRING.fieldOf("title").forGetter(MusicLabelComponent::title), (App)Codec.INT.fieldOf("primaryColor").forGetter(MusicLabelComponent::primaryColor), (App)Codec.INT.fieldOf("secondaryColor").forGetter(MusicLabelComponent::secondaryColor)).apply((Applicative)instance, MusicLabelComponent::new));
    private static final Codec<MusicLabelComponent> SIMPLE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("author").forGetter(MusicLabelComponent::artist), (App)Codec.STRING.fieldOf("title").forGetter(MusicLabelComponent::title), (App)Codec.INT.fieldOf("color").forGetter(MusicLabelComponent::primaryColor)).apply((Applicative)instance, MusicLabelComponent::new));
    public static final Codec<MusicLabelComponent> CODEC = Codec.withAlternative(SIMPLE_CODEC, COMPLEX_CODEC);
    public static final StreamCodec<FriendlyByteBuf, MusicLabelComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, MusicLabelComponent::artist, (StreamCodec)ByteBufCodecs.STRING_UTF8, MusicLabelComponent::title, (StreamCodec)ByteBufCodecs.INT, MusicLabelComponent::primaryColor, (StreamCodec)ByteBufCodecs.INT, MusicLabelComponent::secondaryColor, MusicLabelComponent::new);

    public MusicLabelComponent(String artist, String title, int primaryColor, int secondaryColor) {
        this.artist = artist;
        this.title = title;
        this.primaryColor = 0xFFFFFF & primaryColor;
        this.secondaryColor = 0xFFFFFF & secondaryColor;
    }

    public MusicLabelComponent(String author, String title, int color) {
        this(author, title, color, color);
    }

    public int primaryColor() {
        return 0xFF000000 | this.primaryColor;
    }

    public int secondaryColor() {
        return 0xFF000000 | this.secondaryColor;
    }

    public boolean simple() {
        return this.primaryColor == this.secondaryColor;
    }

    public boolean isColored() {
        return this.primaryColor != 0xFFFFFF || this.secondaryColor != 0xFFFFFF;
    }

    public MusicLabelComponent withArtist(String author) {
        return new MusicLabelComponent(author, this.title, this.primaryColor, this.secondaryColor);
    }

    public MusicLabelComponent withTitle(String title) {
        return new MusicLabelComponent(this.artist, title, this.primaryColor, this.secondaryColor);
    }

    public MusicLabelComponent withInfo(String artist, String title) {
        return new MusicLabelComponent(artist, title, this.primaryColor, this.secondaryColor);
    }

    public MusicLabelComponent withColor(int color) {
        return new MusicLabelComponent(this.artist, this.title, color, color);
    }

    public MusicLabelComponent withColor(int primaryColor, int secondaryColor) {
        return new MusicLabelComponent(this.artist, this.title, primaryColor, secondaryColor);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (!this.artist.isEmpty() && !this.title.isEmpty()) {
            tooltipAdder.accept((Component)Component.translatable((String)"sound_source.etched.info", (Object[])new Object[]{this.artist, this.title}).withStyle(ChatFormatting.GRAY));
        }
        if (this.primaryColor != 0xFFFFFF || this.secondaryColor != 0xFFFFFF) {
            if (tooltipFlag.isAdvanced()) {
                if (this.simple()) {
                    tooltipAdder.accept((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.primaryColor)}).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltipAdder.accept((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.primaryColor)}).withStyle(ChatFormatting.GRAY));
                    tooltipAdder.accept((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.secondaryColor)}).withStyle(ChatFormatting.GRAY));
                }
            } else {
                tooltipAdder.accept((Component)Component.translatable((String)"item.dyed").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }
    }
}

