/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import gg.moonflower.etched.common.component.AlbumCoverComponent;
import gg.moonflower.etched.core.registry.EtchedComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AlbumCoverContainer
implements Container {
    private final AlbumCoverComponent.Builder builder;
    private final Inventory inventory;
    private final int index;

    public AlbumCoverContainer(Inventory inventory, int index) {
        this.builder = AlbumCoverComponent.builder(inventory.getItem(index));
        this.inventory = inventory;
        this.index = index;
    }

    public int getContainerSize() {
        return this.builder.getContainerSize();
    }

    public boolean isEmpty() {
        return this.builder.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.builder.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack removed = this.builder.removeItem(slot, amount);
        this.setChanged();
        return removed;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack removed = this.builder.removeItemNoUpdate(slot);
        this.setChanged();
        return removed;
    }

    public void setItem(int slot, ItemStack stack) {
        this.builder.setItem(slot, stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.builder.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.builder.getMaxStackSize(stack);
    }

    public void setChanged() {
        this.builder.setChanged();
        this.inventory.getItem(this.index).set(EtchedComponents.ALBUM_COVER, (Object)this.builder.build());
    }

    public boolean stillValid(Player player) {
        return this.builder.stillValid(player);
    }

    public void startOpen(Player player) {
        this.builder.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.builder.stopOpen(player);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.builder.canPlaceItem(slot, stack);
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return this.builder.canTakeItem(target, slot, stack);
    }

    public void clearContent() {
        this.builder.clearContent();
    }
}

