/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.jukebox;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.common.network.play.ClientboundPlayBlockMusicPacket;
import gg.moonflower.etched.core.mixin.jukebox.JukeboxSongPlayerAccessor;
import gg.moonflower.etched.core.registry.EtchedComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSongPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JukeboxBlockEntity.class})
public abstract class JukeboxBlockEntityMixin
extends BlockEntity {
    @Shadow
    private ItemStack item;
    @Shadow
    @Final
    private JukeboxSongPlayer jukeboxSongPlayer;
    @Unique
    private boolean etched$playing;

    @Shadow
    public abstract void onSongChanged();

    public JukeboxBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(method={"setTheItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/JukeboxSongPlayer;stop(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    public void stop(ItemStack stack, CallbackInfo ci) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getBlockPos();
            if (PlayableRecord.isPlayableRecord(stack)) {
                PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)64.0, (CustomPacketPayload)new ClientboundPlayBlockMusicPacket(stack.copy(), pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.etched$playing = true;
            } else if (this.etched$playing) {
                this.etched$playing = false;
                ((JukeboxSongPlayerAccessor)this.jukeboxSongPlayer).setTicksSinceSongStarted(0L);
                this.level.gameEvent((Holder)GameEvent.JUKEBOX_STOP_PLAY, pos, GameEvent.Context.of((BlockState)this.getBlockState()));
                this.level.levelEvent(1011, pos, 0);
                this.onSongChanged();
            }
        }
    }

    @Inject(method={"getComparatorOutput"}, at={@At(value="TAIL")}, cancellable=true)
    public void getComparatorOutput(CallbackInfoReturnable<Integer> cir) {
        if (cir.getReturnValueI() == 0 && PlayableRecord.isPlayableRecord(this.item)) {
            cir.setReturnValue((Object)15);
        }
    }

    @Inject(method={"canPlaceItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void canPlaceItem(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        JukeboxBlockEntity self = (JukeboxBlockEntity)this;
        if (stack.has(EtchedComponents.DISC_APPEARANCE) && self.getItem(slot).isEmpty()) {
            cir.setReturnValue((Object)true);
        }
    }
}

