/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.comparator.DoubleComparator;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

public class ItemStackCheck {
    public static final Codec<ItemStackCheck> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.ITEM_CODEC.fieldOf("item").forGetter(itemStackCheck -> itemStackCheck.item), (App)DoubleComparator.CODEC.optionalFieldOf("durability_is").forGetter(itemStackCheck -> itemStackCheck.durabilityComparator), (App)DoubleComparator.CODEC.optionalFieldOf("stack_size_is").forGetter(itemStackCheck -> itemStackCheck.stackSizeComparator), (App)Codec.unboundedMap((Codec)class_1887.field_51644, DoubleComparator.CODEC).optionalFieldOf("enchantment_check").forGetter(itemStackCheck -> itemStackCheck.enchantmentLevelComparator)).apply((Applicative)builder, ItemStackCheck::new));
    private final class_1792 item;
    private final Optional<DoubleComparator> durabilityComparator;
    private final Optional<DoubleComparator> stackSizeComparator;
    private final Optional<Map<class_6880<class_1887>, DoubleComparator>> enchantmentLevelComparator;

    public ItemStackCheck(class_1792 item, Optional<DoubleComparator> durabilityComparator, Optional<DoubleComparator> stackSizeComparator, Optional<Map<class_6880<class_1887>, DoubleComparator>> enchantmentLevelComparator) {
        this.item = item;
        if (durabilityComparator.isEmpty() && stackSizeComparator.isEmpty() && enchantmentLevelComparator.isEmpty()) {
            throw new IllegalArgumentException("We need at least one check in an Item Stack Check!");
        }
        this.durabilityComparator = durabilityComparator;
        this.stackSizeComparator = stackSizeComparator;
        this.enchantmentLevelComparator = enchantmentLevelComparator;
    }

    public boolean test(class_1799 itemStack) {
        if (this.item == itemStack.method_7909()) {
            if (this.durabilityComparator.isPresent() && !this.durabilityComparator.get().check(itemStack.method_7919())) {
                return false;
            }
            if (this.stackSizeComparator.isPresent() && !this.stackSizeComparator.get().check(itemStack.method_7947())) {
                return false;
            }
            if (this.enchantmentLevelComparator.isPresent()) {
                Map<class_6880<class_1887>, DoubleComparator> enchantmentComparator = this.enchantmentLevelComparator.get();
                class_9304 enchantments = itemStack.method_58657();
                Set holders = enchantments.method_57534();
                for (class_6880 enchantmentHolder : holders) {
                    DoubleComparator doubleComparator;
                    if (!enchantmentComparator.containsKey(enchantmentHolder) || (doubleComparator = enchantmentComparator.get(enchantmentHolder)).check(enchantments.method_57536(enchantmentHolder))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public class_1792 getItem() {
        return this.item;
    }
}

