/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.forge.platform;

import com.google.auto.service.AutoService;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.platform.ModPlatform;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.DeferredRegister;

@AutoService(value={ModPlatform.class})
public class ForgePlatform
implements ModPlatform {
    public static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();
    public static final List<Consumer<DataPackRegistryEvent.NewRegistry>> DATAPACK_REGISTRIES = new ArrayList<Consumer<DataPackRegistryEvent.NewRegistry>>();

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Collection<String> getModIDS() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }

    @Override
    public Path configDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public <T> Supplier<T> register(Registry<T> registry, String location, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"corgilib")).register(location, value);
    }

    @Override
    public <T> Supplier<Registry<T>> createSimpleBuiltin(ResourceKey<Registry<T>> registryKey) {
        Registry registry = BuiltInRegistries.REGISTRY;
        if (registry instanceof MappedRegistry) {
            MappedRegistry mappedRegistry = (MappedRegistry)registry;
            mappedRegistry.unfreeze();
        }
        Registry registry2 = BuiltInRegistries.registerSimple(registryKey, builder -> new Object());
        Registry registry3 = BuiltInRegistries.REGISTRY;
        if (registry3 instanceof MappedRegistry) {
            MappedRegistry mappedRegistry = (MappedRegistry)registry3;
            mappedRegistry.freeze();
        }
        return () -> registry2;
    }

    @Override
    public <T> void registerDatapackRegistry(ResourceKey<Registry<T>> key, Supplier<Codec<T>> codec) {
        DATAPACK_REGISTRIES.add(newRegistry -> newRegistry.dataPackRegistry(key, (Codec)codec.get()));
    }
}

