/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.losemaxhpondeath;

import com.google.common.base.Predicates;
import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="losemaxhpondeath")
public class HealthChangeHandler {
    private static final Logger log = LogUtils.getLogger();
    private static final String MODIFIER_NAME = "death_health_penalty_modifier";
    private static final ResourceLocation MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"losemaxhpondeath", (String)"death_health_penalty_modifier");
    private static final double MIN_HEALTH_CAP = 1.0;
    private static final double MAX_HEALTH_CAP = 20.0;
    private static final String NBT_KEY_SAVED_MAX_HEALTH = "DHPC_MAX_HEALTH";

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            CompoundTag oldData = oldPlayer.getPersistentData();
            CompoundTag newData = newPlayer.getPersistentData();
            if (oldData.contains(NBT_KEY_SAVED_MAX_HEALTH)) {
                double savedMaxHealth = oldData.getDouble(NBT_KEY_SAVED_MAX_HEALTH);
                newData.putDouble(NBT_KEY_SAVED_MAX_HEALTH, savedMaxHealth);
            }
            if (oldData.contains("hp_increase_last_tick")) {
                long timerValue = oldData.getLong("hp_increase_last_tick");
                newData.putLong("hp_increase_last_tick", timerValue);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        AttributeInstance attrInstance = player.getAttribute(Attributes.MAX_HEALTH);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.getValue();
        player.getPersistentData().putDouble(NBT_KEY_SAVED_MAX_HEALTH, currentMaxHealth);
        long currentTime = player.level().getGameTime();
        player.getPersistentData().putLong("hp_increase_last_tick", currentTime);
        log.debug("Saved max health {} and hp increase timer start {} for player {}", new Object[]{currentMaxHealth, currentTime, player.getName().getString()});
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        AttributeMap attributes = player.getAttributes();
        AttributeInstance attrInstance = attributes.getInstance(Attributes.MAX_HEALTH);
        if (attrInstance == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.contains(NBT_KEY_SAVED_MAX_HEALTH)) {
            log.debug("No saved max health found for player {} on respawn", (Object)player.getName().getString());
            return;
        }
        double savedMaxHealth = playerData.getDouble(NBT_KEY_SAVED_MAX_HEALTH);
        double halfMaxHealth = Math.max(savedMaxHealth / 2.0, 1.0);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, -attrInstance.getBaseValue() + halfMaxHealth, AttributeModifier.Operation.ADD_VALUE);
        attrInstance.addOrReplacePermanentModifier(modifier);
        log.debug("Applied half max health modifier {} for player {} on respawn", (Object)halfMaxHealth, (Object)player.getName().getString());
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem().getItem();
        AttributeInstance attrInstance = player.getAttribute(Attributes.MAX_HEALTH);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.getValue();
        double increaseAmount = 0.0;
        if (item == Items.GOLDEN_APPLE) {
            increaseAmount = 6.0;
        } else if (item == Items.ENCHANTED_GOLDEN_APPLE) {
            increaseAmount = 20.0;
        }
        if (increaseAmount > 0.0) {
            double newHealth = currentMaxHealth + increaseAmount;
            if (newHealth > 20.0) {
                newHealth = 20.0;
            }
            if (newHealth > currentMaxHealth) {
                AttributeModifier existing = attrInstance.getModifier(MODIFIER_ID);
                if (existing == null) {
                    return;
                }
                AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, Math.clamp(existing.amount() + increaseAmount, -19.0, 0.0), AttributeModifier.Operation.ADD_VALUE);
                attrInstance.addOrReplacePermanentModifier(modifier);
                log.debug("Increased max health for player {} to {}", (Object)player.getName().getString(), (Object)newHealth);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        AttributeInstance attrInstance = player.getAttribute(Attributes.MAX_HEALTH);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.getValue();
        double increaseAmount = 6.0;
        if (increaseAmount > 0.0) {
            double newHealth = currentMaxHealth + increaseAmount;
            if (newHealth > 20.0) {
                newHealth = 20.0;
            }
            if (newHealth > currentMaxHealth) {
                AttributeModifier existing = attrInstance.getModifier(MODIFIER_ID);
                if (existing == null) {
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, newHealth - attrInstance.getBaseValue(), AttributeModifier.Operation.ADD_VALUE);
                    attrInstance.addOrReplacePermanentModifier(modifier);
                } else {
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, Math.clamp(existing.amount() + increaseAmount, -19.0, 0.0), AttributeModifier.Operation.ADD_VALUE);
                    attrInstance.addOrReplacePermanentModifier(modifier);
                }
                log.debug("Increased max health for player {} after sleep to {}", (Object)player.getName().getString(), (Object)newHealth);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        for (ServerLevel level : server.getAllLevels()) {
            for (ServerPlayer entity : level.getPlayers((Predicate)Predicates.alwaysTrue())) {
                AttributeInstance attrInstance;
                ServerPlayer player;
                CompoundTag data;
                if (!(entity instanceof Player) || !(data = (player = entity).getPersistentData()).contains(NBT_KEY_SAVED_MAX_HEALTH) || !data.contains("hp_increase_last_tick")) continue;
                long lastTick = data.getLong("hp_increase_last_tick");
                long currentTime = player.level().getGameTime();
                if (currentTime - lastTick < 12000L || (attrInstance = player.getAttribute(Attributes.MAX_HEALTH)) == null) continue;
                AttributeModifier existing = attrInstance.getModifier(MODIFIER_ID);
                double currentAmount = existing != null ? existing.amount() : 0.0;
                double increaseAmount = 6.0;
                double currentMaxHealth = attrInstance.getBaseValue() + currentAmount;
                double newMaxHealth = currentMaxHealth + increaseAmount;
                if (newMaxHealth > 20.0) {
                    newMaxHealth = 20.0;
                }
                if (newMaxHealth > currentMaxHealth) {
                    double newModifierAmount = newMaxHealth - attrInstance.getBaseValue();
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, Math.clamp(newModifierAmount, -19.0, 0.0), AttributeModifier.Operation.ADD_VALUE);
                    attrInstance.addOrReplacePermanentModifier(modifier);
                    data.putLong("hp_increase_last_tick", currentTime);
                    log.debug("Periodic max HP increase for player {} to {}", (Object)player.getName().getString(), (Object)newMaxHealth);
                    continue;
                }
                data.remove("hp_increase_last_tick");
            }
        }
    }
}

