/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.deathhealthpenalty;

import com.google.common.base.Predicates;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="death_health_penalty")
public class HealthChangeHandler {
    private static final Logger log = LogUtils.getLogger();
    private static final String MODIFIER_NAME = "death_health_penalty_modifier";
    private static final UUID MODIFIER_ID = UUID.fromString("ce99b11e-11b0-4f1c-8e1a-8f9d7e5a64e8");
    private static final double MIN_HEALTH_CAP = 1.0;
    private static final double MAX_HEALTH_CAP = 20.0;
    private static final String NBT_KEY_SAVED_MAX_HEALTH = "DHPC_MAX_HEALTH";
    public static final String HP_INCREASE_LAST_TICK = "hp_increase_last_tick";

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            CompoundTag oldData = oldPlayer.getPersistentData();
            CompoundTag newData = newPlayer.getPersistentData();
            if (oldData.m_128441_(NBT_KEY_SAVED_MAX_HEALTH)) {
                double savedMaxHealth = oldData.m_128459_(NBT_KEY_SAVED_MAX_HEALTH);
                newData.m_128347_(NBT_KEY_SAVED_MAX_HEALTH, savedMaxHealth);
            }
            if (oldData.m_128441_(HP_INCREASE_LAST_TICK)) {
                long timerValue = oldData.m_128454_(HP_INCREASE_LAST_TICK);
                newData.m_128356_(HP_INCREASE_LAST_TICK, timerValue);
            }
            HealthChangeHandler.reduceHpAfterDeath(newPlayer);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        AttributeInstance attrInstance = player.m_21051_(Attributes.f_22276_);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.m_22135_();
        player.getPersistentData().m_128347_(NBT_KEY_SAVED_MAX_HEALTH, currentMaxHealth);
        long currentTime = player.m_9236_().m_46467_();
        player.getPersistentData().m_128356_(HP_INCREASE_LAST_TICK, currentTime);
        log.debug("Saved max health {} and hp increase timer start {} for player {}", new Object[]{currentMaxHealth, currentTime, player.m_7755_().getString()});
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
    }

    private static void reduceHpAfterDeath(Player player) {
        AttributeMap attributes = player.m_21204_();
        AttributeInstance attrInstance = attributes.m_22146_(Attributes.f_22276_);
        if (attrInstance == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.m_128441_(NBT_KEY_SAVED_MAX_HEALTH)) {
            log.debug("No saved max health found for player {} on respawn", (Object)player.m_7755_().getString());
            return;
        }
        double savedMaxHealth = playerData.m_128459_(NBT_KEY_SAVED_MAX_HEALTH);
        double halfMaxHealth = Math.max(savedMaxHealth / 2.0, 1.0);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, -attrInstance.m_22115_() + halfMaxHealth, AttributeModifier.Operation.ADDITION);
        attrInstance.m_22127_(MODIFIER_ID);
        attrInstance.m_22120_(MODIFIER_ID);
        attrInstance.m_22125_(modifier);
        player.m_21153_(player.m_21233_());
        log.debug("Applied half max health modifier {} for player {} on respawn", (Object)halfMaxHealth, (Object)player.m_7755_().getString());
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem().m_41720_();
        AttributeInstance attrInstance = player.m_21051_(Attributes.f_22276_);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.m_22135_();
        double increaseAmount = 0.0;
        if (item == Items.f_42436_) {
            increaseAmount = 6.0;
        } else if (item == Items.f_42437_) {
            increaseAmount = 20.0;
        }
        if (increaseAmount > 0.0) {
            double newHealth = currentMaxHealth + increaseAmount;
            if (newHealth > 20.0) {
                newHealth = 20.0;
            }
            if (newHealth > currentMaxHealth) {
                AttributeModifier existing = attrInstance.m_22111_(MODIFIER_ID);
                if (existing == null) {
                    return;
                }
                AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, HealthChangeHandler.clamp(existing.m_22218_() + increaseAmount, -19.0, 0.0), AttributeModifier.Operation.ADDITION);
                attrInstance.m_22127_(MODIFIER_ID);
                attrInstance.m_22120_(MODIFIER_ID);
                attrInstance.m_22125_(modifier);
                log.debug("Increased max health for player {} to {}", (Object)player.m_7755_().getString(), (Object)newHealth);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        AttributeInstance attrInstance = player.m_21051_(Attributes.f_22276_);
        if (attrInstance == null) {
            return;
        }
        double currentMaxHealth = attrInstance.m_22135_();
        double increaseAmount = 6.0;
        if (increaseAmount > 0.0) {
            double newHealth = currentMaxHealth + increaseAmount;
            if (newHealth > 20.0) {
                newHealth = 20.0;
            }
            if (newHealth > currentMaxHealth) {
                AttributeModifier existing = attrInstance.m_22111_(MODIFIER_ID);
                if (existing == null) {
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, newHealth - attrInstance.m_22115_(), AttributeModifier.Operation.ADDITION);
                    attrInstance.m_22127_(MODIFIER_ID);
                    attrInstance.m_22120_(MODIFIER_ID);
                    attrInstance.m_22125_(modifier);
                } else {
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, HealthChangeHandler.clamp(existing.m_22218_() + increaseAmount, -19.0, 0.0), AttributeModifier.Operation.ADDITION);
                    attrInstance.m_22127_(MODIFIER_ID);
                    attrInstance.m_22120_(MODIFIER_ID);
                    attrInstance.m_22125_(modifier);
                }
                log.debug("Increased max health for player {} after sleep to {}", (Object)player.m_7755_().getString(), (Object)newHealth);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        for (ServerLevel level : server.m_129785_()) {
            for (ServerPlayer player : level.m_8795_((Predicate)Predicates.alwaysTrue())) {
                AttributeInstance attrInstance;
                CompoundTag data = player.getPersistentData();
                if (!data.m_128441_(NBT_KEY_SAVED_MAX_HEALTH) || !data.m_128441_(HP_INCREASE_LAST_TICK)) continue;
                long lastTick = data.m_128454_(HP_INCREASE_LAST_TICK);
                long currentTime = player.m_9236_().m_46467_();
                if (currentTime - lastTick < 12000L || (attrInstance = player.m_21051_(Attributes.f_22276_)) == null) continue;
                AttributeModifier existing = attrInstance.m_22111_(MODIFIER_ID);
                double currentAmount = existing != null ? existing.m_22218_() : 0.0;
                double increaseAmount = 6.0;
                double currentMaxHealth = attrInstance.m_22115_() + currentAmount;
                double newMaxHealth = currentMaxHealth + increaseAmount;
                if (newMaxHealth > 20.0) {
                    newMaxHealth = 20.0;
                }
                if (newMaxHealth > currentMaxHealth) {
                    double newModifierAmount = newMaxHealth - attrInstance.m_22115_();
                    AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, HealthChangeHandler.clamp(newModifierAmount, -19.0, 0.0), AttributeModifier.Operation.ADDITION);
                    attrInstance.m_22127_(MODIFIER_ID);
                    attrInstance.m_22120_(MODIFIER_ID);
                    attrInstance.m_22125_(modifier);
                    data.m_128356_(HP_INCREASE_LAST_TICK, currentTime);
                    log.debug("Periodic max HP increase for player {} to {}", (Object)player.m_7755_().getString(), (Object)newMaxHealth);
                    continue;
                }
                data.m_128473_(HP_INCREASE_LAST_TICK);
            }
        }
    }

    public static double clamp(double value, double min, double max) {
        if (!(min < max)) {
            if (Double.isNaN(min)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(max)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(min, max) > 0) {
                throw new IllegalArgumentException(min + " > " + max);
            }
        }
        return Math.min(max, Math.max(value, min));
    }
}

