/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.GameInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import ru.maxthetomas.e418.config.ConfigLoader;
import ru.maxthetomas.e418.debug.EventCommand;
import ru.maxthetomas.e418.event.EventManager;
import ru.maxthetomas.e418.event.engine.EventEngines;
import ru.maxthetomas.e418.networking.E418Networking;
import ru.maxthetomas.e418.util.E418Random;
import ru.maxthetomas.e418.util.E418Variables;
import ru.maxthetomas.e418.util.storage.InGameStorage;

public final class E418 {
    public static final String MOD_ID = "e418";
    private static final EventManager EventManager = new EventManager();
    private static final EventEngines EventEngine = new EventEngines();
    private static MinecraftServer ManagedServer = null;

    public static void init() {
        ConfigLoader.loadConfig();
        E418Networking.init();
        CommandRegistrationEvent.EVENT.register(EventCommand::register);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)EventManager, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"event_reload_listener"));
        E418.registerListeners();
        ConfigLoader.saveConfig();
    }

    private static void registerListeners() {
        LifecycleEvent.SERVER_BEFORE_START.register(srv -> {
            EventManager.init();
            EventManager.getActiveEvents().forEach(EventManager::disposeEvent);
            E418Variables.init();
            ManagedServer = srv;
        });
        LifecycleEvent.SERVER_LEVEL_LOAD.register(lvl -> {
            if (lvl.equals(ManagedServer.method_30002())) {
                E418Random.init(lvl);
            }
        });
        LifecycleEvent.SERVER_STARTED.register(InGameStorage::load);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(savedWorld -> {
            if (!savedWorld.equals(savedWorld.method_8503().method_30002())) {
                return;
            }
            InGameStorage.INSTANCE.dumpEventManager(E418.getEventManager());
        });
        LifecycleEvent.SERVER_STOPPING.register(srv -> {
            InGameStorage.INSTANCE.dumpEventManager(E418.getEventManager());
            E418.getEventManager().fullReset((MinecraftServer)srv);
        });
        LifecycleEvent.SERVER_STOPPED.register(srv -> {
            if (srv.equals(ManagedServer)) {
                ManagedServer = null;
            }
            E418Variables.init();
        });
    }

    public static EventManager getEventManager() {
        return EventManager;
    }

    public static EventEngines getEventEngine() {
        return EventEngine;
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(GameInstance.getServer());
    }

    public static List<class_3222> allPlayers() {
        if (E418.getCurrentServer().isEmpty()) {
            return List.of();
        }
        return E418.getCurrentServer().get().method_3760().method_14571();
    }

    @Nullable
    public static class_3222 player(UUID uuid) {
        if (E418.getCurrentServer().isEmpty()) {
            return null;
        }
        return E418.getCurrentServer().get().method_3760().method_14602(uuid);
    }

    public static class_2960 resLoc(String value) {
        return class_2960.method_60655((String)MOD_ID, (String)value);
    }
}

