/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.codecs.numberprovider.NumberRequester;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public abstract class Behaviour
implements NumberRequester {
    protected IBehaviourExecutor executor;
    protected EventContext context;
    private boolean isDisposed = false;
    private boolean isStopped = false;
    private boolean isExecuted = false;
    private boolean isDone = false;

    public abstract class_2960 getTypeId();

    public void execute(EventContext context, IBehaviourExecutor executor) {
        this.isExecuted = true;
        this.executor = executor;
        this.context = context;
    }

    public void dispose() {
        this.isDisposed = true;
        this.isStopped = true;
        this.setDone(true);
    }

    public void stop() {
        this.dispose();
    }

    public final void tryExecute(EventContext context, IBehaviourExecutor executor) {
        if (this.isExecuted) {
            return;
        }
        this.execute(context, executor);
        this.isExecuted = true;
    }

    public final void tryStop() {
        if (!this.isExecuted || this.isStopped) {
            return;
        }
        this.stop();
        this.isStopped = true;
    }

    public final void tryDispose() {
        if (!this.isExecuted || this.isDisposed) {
            return;
        }
        this.dispose();
        this.isDisposed = true;
    }

    public void tick() {
    }

    public boolean canRun(EventContext context) {
        return true;
    }

    public final boolean isDone() {
        return this.isDone;
    }

    public final void setDone(boolean value) {
        this.isDone = value;
        if (this.executor != null) {
            this.executor.dirty();
        } else {
            LogUtils.getLogger().warn("Could not update executor in {} because it's not defined!", (Object)this.getClass().getName());
        }
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    public final boolean isExecuted() {
        return this.isExecuted;
    }

    protected void _resetExecuted() {
        this.isExecuted = false;
    }

    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        this.executor = executor;
        this.context = context;
        this.executor.dirty();
    }

    public record BehaviourState(boolean isDone, boolean isDisposed, boolean isStopped, boolean isExecuted) {
        public static final MapCodec<BehaviourState> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.lenientOptionalFieldOf("is_done", (Object)false).forGetter(v -> v.isDone), (App)Codec.BOOL.lenientOptionalFieldOf("is_disposed", (Object)false).forGetter(v -> v.isDisposed), (App)Codec.BOOL.lenientOptionalFieldOf("is_stopped", (Object)false).forGetter(v -> v.isStopped), (App)Codec.BOOL.lenientOptionalFieldOf("is_executed", (Object)false).forGetter(v -> v.isExecuted)).apply((Applicative)i, BehaviourState::new));

        public void apply(Behaviour behaviour) {
            behaviour.isExecuted = this.isExecuted;
            behaviour.isDone = this.isDone;
            behaviour.isDisposed = this.isDisposed;
            behaviour.isStopped = this.isStopped;
        }

        public static BehaviourState create(Behaviour behaviour) {
            return new BehaviourState(behaviour.isDone, behaviour.isDisposed, behaviour.isStopped, behaviour.isExecuted);
        }
    }
}

