/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour;

import java.util.List;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.behaviour.PreActiveBehaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public abstract class ExecutorBehaviour
extends Behaviour
implements IBehaviourExecutor {
    protected List<Behaviour> activeBehaviours;

    public ExecutorBehaviour(List<PreActiveBehaviour> behaviours) {
        this.activeBehaviours = behaviours.stream().map(PreActiveBehaviour::create).toList();
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        this.context = context;
        super.execute(context, executor);
    }

    protected boolean tryStartBehaviours() {
        if (this.activeBehaviours.stream().anyMatch(v -> !v.canRun(this.context))) {
            return false;
        }
        this.activeBehaviours.forEach(b -> b.tryExecute(this.context, this));
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        this.activeBehaviours.forEach(Behaviour::tick);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Behaviour behaviour : this.activeBehaviours) {
            behaviour.dispose();
        }
    }

    @Override
    public void stop() {
        super.stop();
        for (Behaviour behaviour : this.activeBehaviours) {
            behaviour.stop();
        }
    }

    @Override
    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        super.restoreState(context, executor);
        this.activeBehaviours.forEach(v -> v.restoreState(context, this));
        this.dirty();
    }

    @Override
    public List<Behaviour> getExecutedBehaviours() {
        return this.activeBehaviours;
    }

    @Override
    public void dirty() {
        for (Behaviour behaviour : this.activeBehaviours) {
            if (behaviour.isDone()) continue;
            this.setDone(false);
            return;
        }
        this.setDone(true);
    }
}

