/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.contextmutators.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.contextmutators.IContextMutator;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProviders;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.util.E418Random;
import ru.maxthetomas.e418.util.Location;

public class SelectRandomLocationAroundPlayerContextMutator
implements IContextMutator {
    public static final class_2960 ID = E418.resLoc("select_random_location_around_player");
    public static final MapCodec<SelectRandomLocationAroundPlayerContextMutator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(NumberProviders.codec("radius", Float.valueOf(16.0f), SelectRandomLocationAroundPlayerContextMutator::getRange), (App)class_2960.field_25139.optionalFieldOf("random_sequence", (Object)E418Random.EVENT_GENERIC_RESOURCE).forGetter(SelectRandomLocationAroundPlayerContextMutator::getRandomSequence), (App)Codec.BOOL.optionalFieldOf("use_heightmap", (Object)false).forGetter(v -> v.useHeightmap), (App)class_2902.class_2903.field_24772.optionalFieldOf("heightmap_type", (Object)class_2902.class_2903.field_13203).forGetter(v -> v.heightMapType)).apply((Applicative)instance, SelectRandomLocationAroundPlayerContextMutator::new));
    private final NumberProvider range;
    private final class_2960 randomSequence;
    private final boolean useHeightmap;
    private final class_2902.class_2903 heightMapType;

    public SelectRandomLocationAroundPlayerContextMutator(NumberProvider range, class_2960 randomSequence, boolean useHeightmap, class_2902.class_2903 heightMapType) {
        this.range = range;
        this.randomSequence = randomSequence;
        this.useHeightmap = useHeightmap;
        this.heightMapType = heightMapType;
    }

    public NumberProvider getRange() {
        return this.range;
    }

    private class_2960 getRandomSequence() {
        return this.randomSequence;
    }

    @Override
    public boolean mutate(EventContext context) {
        class_3222 player = context.getPlayer();
        if (player == null) {
            return false;
        }
        Location location = Location.fromPlayer(player);
        class_5819 random = context.getServer().method_30002().method_51836(this.randomSequence);
        float range_value = this.range.get().floatValue();
        class_243 position = location.position().method_1031((double)((random.method_43057() - 0.5f) * range_value * 2.0f), (double)((random.method_43057() - 0.5f) * range_value * 2.0f), (double)((random.method_43057() - 0.5f) * range_value * 2.0f));
        if (this.useHeightmap) {
            position = new class_243(position.field_1352, (double)location.level().method_8624(this.heightMapType, location.getBlockPosition().method_10263(), location.getBlockPosition().method_10260()), position.field_1350);
        }
        Location newLocation = new Location(location.levelId(), position);
        context.withLocation(newLocation);
        return true;
    }

    @Override
    public class_2960 getType() {
        return ID;
    }
}

