/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.serialization.MapCodec;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;
import ru.maxthetomas.e418.networking.S2CSetBreakAtlas;

public class BreakAtlasBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("break_atlas");
    public static final MapCodec<BreakAtlasBehaviour> CODEC = MapCodec.unit(BreakAtlasBehaviour::new);
    public static final MapCodec<BreakAtlasBehaviour> STATE_CODEC = MapCodec.unit(BreakAtlasBehaviour::new);

    public BreakAtlasBehaviour() {
        this.register();
    }

    void register() {
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
    }

    void unregister() {
        PlayerEvent.PLAYER_JOIN.unregister(this::onPlayerJoin);
    }

    void onPlayerJoin(class_3222 player) {
        if (this.isExecuted() && !this.isDone() && (!this.context.hasPlayer() || this.context.getPlayerUUID().equals(player.method_5667()))) {
            this.setBreakAtlas(player, true);
        }
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.setBreakAtlas(context.getPlayer(), true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unregister();
        this.setBreakAtlas(this.context.getPlayer(), false);
    }

    private void setBreakAtlas(class_3222 player, boolean value) {
        if (player == null) {
            NetworkManager.sendToPlayers(E418.allPlayers(), (class_8710)new S2CSetBreakAtlas(value));
        } else {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetBreakAtlas(value));
        }
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }
}

