/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.codecs.FogCodecs;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;
import ru.maxthetomas.e418.networking.S2CSetFog;

public class FogOverrideBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("fog_override");
    public static final MapCodec<FogOverrideBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FogCodecs.CODEC.fieldOf("fog").forGetter(b -> b.config)).apply((Applicative)instance, FogOverrideBehaviour::new));
    public static final MapCodec<FogOverrideBehaviour> STATE_CODEC = CODEC;
    final FogCodecs.FogConfig config;

    public FogOverrideBehaviour(FogCodecs.FogConfig config) {
        this.config = config;
        PlayerEvent.PLAYER_JOIN.register(this::playerJoin);
    }

    void playerJoin(class_3222 player) {
        if (this.isExecuted() && !this.isDone()) {
            if (this.context.hasPlayer() && !player.method_5667().equals(this.context.getPlayerUUID())) {
                return;
            }
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetFog(true, this.config));
        }
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.apply(new S2CSetFog(true, this.config));
    }

    void apply(S2CSetFog packet) {
        if (this.context.hasPlayer()) {
            if (this.context.getPlayer() == null) {
                return;
            }
            NetworkManager.sendToPlayer((class_3222)this.context.getPlayer(), (class_8710)packet);
            return;
        }
        NetworkManager.sendToPlayers(E418.allPlayers(), (class_8710)packet);
    }

    @Override
    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        super.restoreState(context, executor);
        if (this.isExecuted() && !this.isDone()) {
            this.apply(new S2CSetFog(true, this.config));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        PlayerEvent.PLAYER_JOIN.unregister(this::playerJoin);
        this.apply(new S2CSetFog(false, FogCodecs.FogConfig.EMPTY));
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }
}

