/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.ActiveBehaviourDispatch;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.behaviour.ExecutorBehaviour;
import ru.maxthetomas.e418.behaviour.PreActiveBehaviour;
import ru.maxthetomas.e418.behaviour.contextmutators.ContextMutators;
import ru.maxthetomas.e418.behaviour.contextmutators.IContextMutator;
import ru.maxthetomas.e418.condition.Conditions;
import ru.maxthetomas.e418.condition.ICondition;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class MutateContextBehaviour
extends ExecutorBehaviour {
    public static final class_2960 ID = E418.resLoc("mutate_context");
    public static final MapCodec<MutateContextBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ContextMutators.DISPATCH_CODEC.listOf().fieldOf("mutators").forGetter(MutateContextBehaviour::getContextMutators), (App)PreActiveBehaviour.CODEC.listOf().fieldOf("behaviours").forGetter(a -> List.of()), (App)Conditions.DISPATCH_CODEC.listOf().optionalFieldOf("run_conditions", List.of()).forGetter(MutateContextBehaviour::getRunConditions)).apply((Applicative)instance, MutateContextBehaviour::new));
    public static final MapCodec<MutateContextBehaviour> STATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("data").forGetter(Function.identity()), (App)EventContext.CODEC.fieldOf("stored_context").forGetter(v -> v.storedMutatedContext), (App)ActiveBehaviourDispatch.DISPATCH_CODEC.listOf().fieldOf("active_behaviours").forGetter(v -> v.activeBehaviours)).apply((Applicative)instance, (self, context, children) -> {
        self.storedMutatedContext = context;
        self.activeBehaviours = children;
        return self;
    }));
    public final List<IContextMutator> contextMutators;
    public final List<ICondition> runConditions;
    public EventContext storedMutatedContext;

    public MutateContextBehaviour(List<IContextMutator> contextMutators, List<PreActiveBehaviour> behaviours, List<ICondition> runConditions) {
        super(behaviours);
        this.contextMutators = contextMutators;
        this.runConditions = runConditions;
    }

    @Nullable
    public EventContext getMutatedContext(EventContext context) {
        EventContext mutatedContext = context.clone();
        for (IContextMutator contextMutator : this.contextMutators) {
            if (contextMutator.mutate(mutatedContext)) continue;
            return null;
        }
        return mutatedContext;
    }

    public List<ICondition> getRunConditions() {
        return this.runConditions;
    }

    public List<IContextMutator> getContextMutators() {
        return this.contextMutators;
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.storedMutatedContext = this.getMutatedContext(context);
        if (this.storedMutatedContext == null) {
            return;
        }
        this.context = this.storedMutatedContext;
        this.tryStartBehaviours();
    }

    @Override
    public boolean canRun(EventContext context) {
        EventContext mutatedContext = this.getMutatedContext(context);
        if (mutatedContext == null) {
            return false;
        }
        if (!mutatedContext.isForced()) {
            for (ICondition condition : this.runConditions) {
                if (condition.check(mutatedContext)) continue;
                return false;
            }
        }
        for (Behaviour behaviour : this.activeBehaviours) {
            if (behaviour.canRun(mutatedContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        this.executor = executor;
        this.context = context;
        this.activeBehaviours.forEach(v -> v.restoreState(this.storedMutatedContext, this));
        this.dirty();
    }
}

