/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProviders;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class PlaySoundBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("play_sound");
    public static final MapCodec<PlaySoundBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("sound").forGetter(PlaySoundBehaviour::getSoundEventId), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundBehaviour::getVolume), NumberProviders.codec("range", Float.valueOf(16.0f), PlaySoundBehaviour::getRange), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundBehaviour::getPitch), (App)Codec.STRING.xmap(string -> class_3419.valueOf((String)string.toUpperCase()), class_3419::method_14840).optionalFieldOf("source", (Object)class_3419.field_15256).forGetter(PlaySoundBehaviour::getSoundSource)).apply((Applicative)instance, PlaySoundBehaviour::new));
    public static final MapCodec<PlaySoundBehaviour> STATE_CODEC = MapCodec.unit(PlaySoundBehaviour::new);
    private class_2960 soundEventId;
    private class_3419 source;
    private float volume;
    private NumberProvider range;
    private float pitch;

    public PlaySoundBehaviour(class_2960 soundEventId, float volume, NumberProvider range, float pitch, class_3419 source) {
        this.soundEventId = soundEventId;
        this.source = source;
        this.volume = volume;
        this.range = range;
        this.pitch = pitch;
    }

    private PlaySoundBehaviour() {
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.setDone(true);
        class_3414 soundEvent = new class_3414(this.getSoundEventId(), Optional.of(Float.valueOf(this.getRange().get().floatValue())));
        if (context.getPlayer() == null) {
            if (context.getLocation() == null) {
                return;
            }
            context.getLocation().level().method_45446(context.getLocation().getBlockPosition(), soundEvent, this.getSoundSource(), this.getVolume(), this.getPitch(), true);
            return;
        }
        if (context.getLocation() != null) {
            class_6880 eventHolder = class_7923.field_41172.method_47983((Object)soundEvent);
            class_243 position = context.getLocation().position();
            context.getPlayer().field_13987.method_14364((class_2596)new class_2767(eventHolder, this.getSoundSource(), position.field_1352 + 0.5, position.field_1351 + 0.5, position.field_1350 + 0.5, this.getVolume(), this.getPitch(), 149609L));
        } else {
            context.getPlayer().method_17356(soundEvent, this.getSoundSource(), this.getVolume(), this.getPitch());
        }
    }

    @Override
    public boolean canRun(EventContext context) {
        return context.getPlayer() != null || context.getLocation() != null;
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    public class_2960 getSoundEventId() {
        return this.soundEventId;
    }

    public class_3419 getSoundSource() {
        return this.source;
    }

    public float getVolume() {
        return this.volume;
    }

    public NumberProvider getRange() {
        return this.range;
    }

    public float getPitch() {
        return this.pitch;
    }
}

