/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_7471;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.architecturyevents.CommandEvent;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class PreventChatUsageBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("prevent_chat_usage");
    public static final MapCodec<PreventChatUsageBehaviour> CODEC = MapCodec.unit(PreventChatUsageBehaviour::new);
    public static final MapCodec<PreventChatUsageBehaviour> STATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4844.field_25122.lenientOptionalFieldOf("player_target").forGetter(v -> Optional.ofNullable(v.playerTarget))).apply((Applicative)instance, PreventChatUsageBehaviour::new));
    private final ChatEvent.Received onChatMessage = this::onChatMessage;
    private final CommandEvent.MsgReceived onMsg = this::onMsg;
    private UUID playerTarget;

    public PreventChatUsageBehaviour() {
        this.registerEvents();
    }

    private PreventChatUsageBehaviour(Optional<UUID> playerTarget) {
        this.playerTarget = playerTarget.orElse(null);
        this.registerEvents();
    }

    void registerEvents() {
        ChatEvent.RECEIVED.register((Object)this.onChatMessage);
        CommandEvent.MSG_RECEIVED.register((Object)this.onMsg);
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.playerTarget = context.hasPlayer() ? context.getPlayerUUID() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        ChatEvent.RECEIVED.unregister((Object)this.onChatMessage);
        CommandEvent.MSG_RECEIVED.unregister((Object)this.onMsg);
    }

    private EventResult onChatMessage(class_3222 serverPlayer, class_2561 component) {
        if (!this.isExecuted() || this.isDisposed() || this.isDone()) {
            return EventResult.pass();
        }
        if (this.playerTarget == null || this.playerTarget.equals(serverPlayer.method_5667())) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private EventResult onMsg(class_7471 msg) {
        if (!this.isExecuted() || this.isDisposed() || this.isDone()) {
            return EventResult.pass();
        }
        if (this.playerTarget == null || this.playerTarget.equals(msg.method_46292())) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    @Override
    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        super.restoreState(context, executor);
        if (!this.isDone() && !this.isDisposed() && this.isExecuted() && context.hasPlayer()) {
            this.playerTarget = context.getPlayerUUID();
        }
    }
}

