/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;
import ru.maxthetomas.e418.networking.S2CSetShader;

public class SetShaderBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("set_shader");
    public static final MapCodec<SetShaderBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("shader", (Object)class_2960.method_60656((String)"empty")).forGetter(SetShaderBehaviour::getShaderId)).apply((Applicative)instance, SetShaderBehaviour::new));
    public static final MapCodec<SetShaderBehaviour> STATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("shader", (Object)class_2960.method_60656((String)"empty")).forGetter(SetShaderBehaviour::getShaderId), (App)class_4844.field_25122.lenientOptionalFieldOf("player_uuid").forGetter(v -> Optional.ofNullable(v.playerUUID))).apply((Applicative)instance, SetShaderBehaviour::new));
    private final class_2960 shaderId;
    private UUID playerUUID = null;

    public SetShaderBehaviour(class_2960 shaderId) {
        this.shaderId = shaderId;
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
    }

    private SetShaderBehaviour(class_2960 shaderId, Optional<UUID> playerUUID) {
        this.playerUUID = playerUUID.orElse(null);
        this.shaderId = shaderId;
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
    }

    private SetShaderBehaviour(class_2960 shaderId, @Nullable UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.shaderId = shaderId;
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
    }

    @Override
    public void stop() {
        PlayerEvent.PLAYER_JOIN.unregister(this::playerJoined);
        super.stop();
    }

    void playerJoined(class_3222 player) {
        if (this.isExecuted() && !this.isDone() && (this.playerUUID == null || player.method_5667().equals(this.playerUUID))) {
            player.method_5682().execute(() -> NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetShader(this.shaderId)));
        }
    }

    public class_2960 getShaderId() {
        return this.shaderId;
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        class_3222 player = context.getPlayer();
        if (context.hasPlayer() && player != null) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetShader(this.shaderId));
            this.playerUUID = player.method_5667();
        } else {
            NetworkManager.sendToPlayers(E418.allPlayers(), (class_8710)new S2CSetShader(this.shaderId));
        }
    }

    @Override
    public void dispose() {
        if (this.playerUUID != null) {
            class_3222 player = E418.player(this.playerUUID);
            if (player == null) {
                return;
            }
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetShader(S2CSetShader.EMPTY_SHADER));
        } else {
            NetworkManager.sendToPlayers(E418.allPlayers(), (class_8710)new S2CSetShader(S2CSetShader.EMPTY_SHADER));
        }
        super.dispose();
    }
}

