/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.serialization.MapCodec;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;
import ru.maxthetomas.e418.networking.S2CSetSnowRender;
import ru.maxthetomas.e418.util.E418Variables;

public class SnowOverrideBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("snow_override");
    public static final MapCodec<SnowOverrideBehaviour> CODEC = MapCodec.unit(SnowOverrideBehaviour::new);
    public static final MapCodec<SnowOverrideBehaviour> STATE_CODEC = MapCodec.unit(SnowOverrideBehaviour::new);

    public SnowOverrideBehaviour() {
        PlayerEvent.PLAYER_JOIN.register(this::playerJoin);
    }

    void playerJoin(class_3222 player) {
        if (E418Variables.ShouldSnow) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new S2CSetSnowRender(true));
        }
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.setSnow(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        PlayerEvent.PLAYER_JOIN.unregister(this::playerJoin);
        this.setSnow(false);
    }

    private void setSnow(boolean value) {
        E418Variables.ShouldSnow = value;
        NetworkManager.sendToPlayers(E418.allPlayers(), (class_8710)new S2CSetSnowRender(value));
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    @Override
    public void restoreState(EventContext context, IBehaviourExecutor executor) {
        super.restoreState(context, executor);
        if (this.isExecuted() && !this.isDone()) {
            this.setSnow(true);
        }
    }
}

