/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProviders;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class TeleportPlayerBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("teleport_player");
    public static final MapCodec<TeleportPlayerBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(NumberProviders.codec("x", TeleportPlayerBehaviour::getX), NumberProviders.codec("y", TeleportPlayerBehaviour::getY), NumberProviders.codec("z", TeleportPlayerBehaviour::getZ), (App)class_2960.field_25139.lenientOptionalFieldOf("level").forGetter(TeleportPlayerBehaviour::getLevel), (App)Codec.BOOL.optionalFieldOf("relative", (Object)true).forGetter(TeleportPlayerBehaviour::isRelative)).apply((Applicative)instance, TeleportPlayerBehaviour::new));
    public static final MapCodec<TeleportPlayerBehaviour> STATE_CODEC = MapCodec.unit(TeleportPlayerBehaviour::new);
    private class_2960 level;
    private boolean relative;
    private NumberProvider x;
    private NumberProvider y;
    private NumberProvider z;

    public TeleportPlayerBehaviour(NumberProvider x, NumberProvider y, NumberProvider z, Optional<class_2960> level, boolean relative) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = level.orElse(null);
        this.relative = relative;
    }

    private TeleportPlayerBehaviour() {
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    public NumberProvider getX() {
        return this.x;
    }

    public NumberProvider getY() {
        return this.y;
    }

    public NumberProvider getZ() {
        return this.z;
    }

    public Optional<class_2960> getLevel() {
        return Optional.ofNullable(this.level);
    }

    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.setDone(true);
        class_3222 player = context.getPlayer();
        float x = this.x.get(context, this).floatValue();
        float y = this.y.get(context, this).floatValue();
        float z = this.z.get(context, this).floatValue();
        if (player == null) {
            return;
        }
        if (this.relative) {
            x += (float)player.method_23317();
            y += (float)player.method_23318();
            z += (float)player.method_23321();
        }
        if (this.level != null) {
            player.method_5731(new class_5454(context.getServer().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.level)), new class_243((double)x, (double)y, (double)z), class_243.field_1353, 0.0f, 0.0f, class_5454.field_52245));
            return;
        }
        player.method_5859((double)x, (double)y, (double)z);
    }

    @Override
    public boolean canRun(EventContext context) {
        return context.getPlayer() != null;
    }
}

