/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProviders;
import ru.maxthetomas.e418.codecs.numberprovider.impl.ConstantNumberProvider;
import ru.maxthetomas.e418.event.ActiveEvent;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class TimeoutBehaviour
extends Behaviour {
    public static final class_2960 ID = E418.resLoc("timeout");
    public static final MapCodec<TimeoutBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(NumberProviders.codec("ticks", TimeoutBehaviour::getTicks)).apply((Applicative)instance, TimeoutBehaviour::new));
    public static final MapCodec<TimeoutBehaviour> STATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("end_tick").forGetter(v -> v.endTick)).apply((Applicative)instance, TimeoutBehaviour::new));
    private final NumberProvider ticks;
    private long endTick = -1L;

    public TimeoutBehaviour(NumberProvider ticks) {
        this.ticks = ticks;
    }

    private TimeoutBehaviour(long endTick) {
        this.endTick = endTick;
        this.ticks = new ConstantNumberProvider(endTick);
    }

    public NumberProvider getTicks() {
        return this.ticks;
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }

    @Override
    public void execute(EventContext context, IBehaviourExecutor executor) {
        super.execute(context, executor);
        this.endTick = (int)(context.getSourceEvent().startTime + this.ticks.get(context, this).longValue());
        this.context = context;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDone()) {
            return;
        }
        if (this.context.getServer().method_30002().method_8510() > this.endTick) {
            this.end(this.context.getSourceEvent());
        }
    }

    private void end(ActiveEvent event) {
        E418.getEventManager().stopEvent(event);
        this.setDone(true);
    }
}

