/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.behaviour.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.ActiveBehaviourDispatch;
import ru.maxthetomas.e418.behaviour.ExecutorBehaviour;
import ru.maxthetomas.e418.behaviour.PreActiveBehaviour;
import ru.maxthetomas.e418.condition.Conditions;
import ru.maxthetomas.e418.condition.ICondition;

public class WaitForConditionBehaviour
extends ExecutorBehaviour {
    public static final class_2960 ID = E418.resLoc("wait_for_conditions");
    public static final MapCodec<WaitForConditionBehaviour> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Conditions.DISPATCH_CODEC.listOf().fieldOf("conditions").forGetter(WaitForConditionBehaviour::getConditions), (App)PreActiveBehaviour.CODEC.listOf().fieldOf("behaviours").forGetter(a -> List.of())).apply((Applicative)instance, WaitForConditionBehaviour::new));
    public static final MapCodec<WaitForConditionBehaviour> STATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("data").forGetter(Function.identity()), (App)Codec.BOOL.lenientOptionalFieldOf("started", (Object)false).forGetter(v -> v.started), (App)ActiveBehaviourDispatch.DISPATCH_CODEC.listOf().fieldOf("active_behaviours").forGetter(v -> v.activeBehaviours)).apply((Applicative)instance, (self, started, activeBehaviours) -> {
        self.started = started;
        self.activeBehaviours = activeBehaviours;
        return self;
    }));
    private final List<ICondition> conditions;
    private boolean started = false;

    public WaitForConditionBehaviour(List<ICondition> conditions, List<PreActiveBehaviour> behaviours) {
        super(behaviours);
        this.conditions = conditions;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDone() || this.started) {
            return;
        }
        boolean allChecksSucceeded = this.conditions.stream().allMatch(c -> c.check(this.context));
        if (!allChecksSucceeded) {
            return;
        }
        this.started = this.tryStartBehaviours();
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    @Override
    public class_2960 getTypeId() {
        return ID;
    }
}

