/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.codecs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_5699;
import org.joml.Vector4f;

public class ColorCodecs {
    public static Codec<Vector4f> STRING_CODEC = Codec.STRING.comapFlatMap(ColorCodecs::parseString, ColorCodecs::toString);
    public static Codec<Vector4f> CODEC = Codec.withAlternative((Codec)class_5699.field_51364, STRING_CODEC);

    public static DataResult<Vector4f> parseString(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() != 6 && color.length() != 8) {
            String c = color;
            return DataResult.error(() -> "Invalid color string (must be RRGGBB or RRGGBBAA): " + c);
        }
        int r = Integer.parseInt(color.substring(0, 2), 16);
        int g = Integer.parseInt(color.substring(2, 4), 16);
        int b = Integer.parseInt(color.substring(4, 6), 16);
        int a = color.length() == 8 ? Integer.parseInt(color.substring(6, 8), 16) : 255;
        return DataResult.success((Object)new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f));
    }

    public static String toString(Vector4f color) {
        int r = Math.round(color.x * 255.0f);
        int g = Math.round(color.y * 255.0f);
        int b = Math.round(color.z * 255.0f);
        int a = Math.round(color.w * 255.0f);
        if (a >= 254) {
            return String.format("#%02X%02X%02X", r, g, b);
        }
        return String.format("#%02X%02X%02X%02X", r, g, b, a);
    }
}

