/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.codecs.numberprovider;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.codecs.numberprovider.NumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.impl.ConfigNumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.impl.ConstantNumberProvider;
import ru.maxthetomas.e418.codecs.numberprovider.impl.RandomNumberProvider;

public class NumberProviders {
    public static final Codec<NumberProvider> VALUE_CODEC = Codec.FLOAT.xmap(NumberProviders::staticProvider, a -> Float.valueOf(a.get(null, null).floatValue()));
    private static final Map<class_2960, MapCodec<? extends NumberProvider>> REGISTRY = new HashMap<class_2960, MapCodec<? extends NumberProvider>>();
    public static final Codec<? extends NumberProvider> DISPATCH_CODEC = class_2960.field_25139.dispatch(NumberProvider::getType, REGISTRY::get);
    public static final Codec<NumberProvider> CODEC = Codec.withAlternative(VALUE_CODEC, DISPATCH_CODEC);
    public static MapCodec<? extends NumberProvider> RANDOM = NumberProviders.register(RandomNumberProvider.ID, RandomNumberProvider.CODEC);
    public static MapCodec<? extends NumberProvider> CONFIG = NumberProviders.register(ConfigNumberProvider.ID, ConfigNumberProvider.CODEC);

    public static MapCodec<? extends NumberProvider> register(class_2960 location, MapCodec<? extends NumberProvider> codec) {
        REGISTRY.put(location, codec);
        return codec;
    }

    private static NumberProvider staticProvider(Number number) {
        return new ConstantNumberProvider(number);
    }

    public static <T> RecordCodecBuilder<T, NumberProvider> codec(String fieldName, Function<T, NumberProvider> getter) {
        return CODEC.fieldOf(fieldName).forGetter(getter);
    }

    public static <T> RecordCodecBuilder<T, NumberProvider> codec(String fieldName, Number defaultValue, Function<T, NumberProvider> getter) {
        return CODEC.optionalFieldOf(fieldName, (Object)NumberProviders.staticProvider(defaultValue)).forGetter(getter);
    }
}

