/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import ru.maxthetomas.e418.codecs.RandomRange;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Value<?>> CONFIG_VALUES = new ArrayList();
    public static final Value<Boolean> forceDebug = Config.field("force_debug", Codec.BOOL, false);
    public static final Value<Boolean> shouldSkipDebugScreen = Config.field("skip_debug_screen", Codec.BOOL, true);
    public static final Value<Boolean> allowGameCrashes = Config.field("allow_game_crashes", Codec.BOOL, true);
    public static final Value<Set<class_2960>> emptyWorlds = Config.field("empty_worlds", class_2960.field_25139.listOf().xmap(Set::copyOf, List::copyOf), Set.of());
    public static final Value<Set<String>> hiddenNamespaces = Config.field("command_hidden_namespaces", Codec.STRING.listOf().xmap(Set::copyOf, List::copyOf), Set.of("e418"));
    public static final Value<Float> baseIntrusiveness = Config.field("base_intrusiveness", Codec.floatRange((float)0.0f, (float)4.0f), Float.valueOf(0.0f));
    public static final Value<Float> wakeUpEventChance = Config.field("wake_up_event_chance", Codec.floatRange((float)0.0f, (float)1.0f), Float.valueOf(0.1f));
    public static final Value<RandomRange> globalRandomEventDelay = Config.field("global_random_event_delay", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));
    public static final Value<RandomRange> globalRandomEventDelayFailure = Config.field("global_random_event_delay_failure", RandomRange.CODEC.codec(), new RandomRange(600, 1200));
    public static final Value<RandomRange> globalRandomEventGracePeriod = Config.field("player_random_event_grace_period", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));
    public static final Value<Float> playerRandomEventGroupDistance = Config.field("player_random_event_group_distance", Codec.floatRange((float)0.0f, (float)50.0f), Float.valueOf(50.0f));
    public static final Value<RandomRange> playerRandomEventDelay = Config.field("player_random_event_delay", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));
    public static final Value<RandomRange> playerRandomEventDelayFailure = Config.field("player_random_event_delay", RandomRange.CODEC.codec(), new RandomRange(600, 1200));
    public static final Value<RandomRange> playerRandomEventOffset = Config.field("player_random_event_offset", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));
    public static final Value<RandomRange> playerRandomEventLock = Config.field("player_random_event_lock", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));
    public static final Value<RandomRange> playerRandomEventGracePeriod = Config.field("player_random_event_grace_period", RandomRange.CODEC.codec(), new RandomRange(1200, 2400));

    public static boolean isDebug() {
        return Platform.isDevelopmentEnvironment() || forceDebug.get() != false;
    }

    public static boolean shouldSkipBackupScreen() {
        return shouldSkipDebugScreen.get();
    }

    public static boolean isEmptyWorld(class_2960 location) {
        return emptyWorlds.get().contains(location);
    }

    public static boolean shouldHideNamespace(class_2960 location) {
        String ns = location.method_12836();
        return hiddenNamespaces.get().contains(ns);
    }

    private static <T> Value<T> field(String name, Codec<T> codec, T defaultValue) {
        Value<T> value = new Value<T>(name, defaultValue, codec);
        CONFIG_VALUES.add(value);
        return value;
    }

    public static boolean deserializeConfig(JsonObject object) {
        return CONFIG_VALUES.stream().allMatch(v -> v.deserializeFromMapAndUpdate(object));
    }

    public static JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        List<Value> failed = CONFIG_VALUES.stream().filter(v -> !v.serializeAndAddToObject(object)).toList();
        if (!failed.isEmpty()) {
            LOGGER.warn("Could not serialize {} value(s) during config serialization.", (Object)failed.size());
        }
        return object;
    }

    public static Optional<Value<?>> getConfigValue(String serializedName) {
        for (Value<?> val : CONFIG_VALUES) {
            if (!val.getSerializedName().equals(serializedName)) continue;
            return Optional.of(val);
        }
        return Optional.empty();
    }

    public static class Value<T> {
        private final String serializedName;
        private final Codec<T> serializer;
        private final T defaultValue;
        private Supplier<T> supplier;

        public Value(String serializedName, T defValue, Codec<T> serializer) {
            this.serializedName = serializedName;
            this.supplier = () -> defValue;
            this.serializer = serializer;
            this.defaultValue = defValue;
        }

        public Codec<T> getSerializer() {
            return this.serializer;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public void set(T value) {
            this.supplier = () -> value;
        }

        public boolean deserializeAndUpdate(JsonElement element) {
            DataResult result = this.getSerializer().decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            result.ifSuccess(v -> this.set(v.getFirst()));
            result.ifError(err -> LOGGER.error("Error while loading value {} from configuration file: {}", (Object)this.serializedName, (Object)err.toString()));
            return result.isSuccess();
        }

        public boolean deserializeFromMapAndUpdate(JsonObject object) {
            JsonElement field = object.get(this.serializedName);
            if (field == null) {
                this.set(this.defaultValue);
                return false;
            }
            return this.deserializeAndUpdate(field);
        }

        public DataResult<JsonElement> serialize() {
            return this.getSerializer().encode(this.get(), (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty());
        }

        public boolean serializeAndAddToObject(JsonObject object) {
            DataResult<JsonElement> serialized = this.serialize();
            serialized.ifSuccess(result -> object.add(this.serializedName, result));
            return serialized.isSuccess();
        }

        public T get() {
            return this.supplier.get();
        }
    }
}

