/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import ru.maxthetomas.e418.config.Config;

public class ConfigLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("e418.json");

    public static void loadConfig() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                return;
            }
            String jsonString = Files.readString(CONFIG_PATH);
            JsonElement configJson = JsonParser.parseString((String)jsonString);
            if (!configJson.isJsonObject()) {
                throw new RuntimeException("Invalid configuration!");
            }
            boolean result = Config.deserializeConfig(configJson.getAsJsonObject());
            if (!result) {
                LOGGER.warn("Error while config deserialization!");
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not load config!", (Throwable)e);
        }
    }

    public static void saveConfig() {
        try {
            JsonObject result = Config.serializeConfig();
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)result), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not save config!", (Throwable)e);
        }
    }
}

