/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.condition.ICondition;
import ru.maxthetomas.e418.event.ActiveEvent;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.EventManager;
import ru.maxthetomas.e418.event.EventResource;
import ru.maxthetomas.e418.event.QueuedEvent;
import ru.maxthetomas.e418.event.cause.impl.ConsoleCommandEventCause;
import ru.maxthetomas.e418.event.registry.EventRegistries;
import ru.maxthetomas.e418.event.registry.EventRegistry;
import ru.maxthetomas.e418.util.WeightedList;
import ru.maxthetomas.e418.util.storage.data.PlayerData;

public class EventCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"event").requires(s -> s.method_9259(2))).then(EventCommand.startEvent())).then(EventCommand.queueEvent())).then(EventCommand.printEvents())).then(EventCommand.stopEvent()));
    }

    private static LiteralArgumentBuilder<class_2168> startEvent() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"start").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"event", (ArgumentType)class_2232.method_9441()).executes(EventCommand::executeStartSubcommand)).suggests(EventCommand::getEventSuggestions).then(class_2170.method_9247((String)"force").executes(EventCommand::executeStartSubcommand))).then(class_2170.method_9247((String)"check").executes(EventCommand::executeStartSubcommand)));
    }

    private static LiteralArgumentBuilder<class_2168> stopEvent() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"stop").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"event", (ArgumentType)class_2232.method_9441()).executes(EventCommand::executeStopSubcommand)).suggests(EventCommand::getActiveEventSuggestions).then(LiteralArgumentBuilder.literal((String)"dispose").executes(EventCommand::executeStopSubcommand)))).then(LiteralArgumentBuilder.literal((String)"all").executes(EventCommand::executeClear));
    }

    private static LiteralArgumentBuilder<class_2168> eventRandomDelays() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"print").then(LiteralArgumentBuilder.literal((String)"delays").executes(EventCommand::executePrintRandomEventDelays));
    }

    private static LiteralArgumentBuilder<class_2168> queueEvent() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"queue").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"event", (ArgumentType)class_2232.method_9441()).executes(EventCommand::executeQueueNoTimeoutSubcommand)).suggests(EventCommand::getEventSuggestions).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"timeout", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(EventCommand::executeQueueSubcommand)).then(class_2170.method_9247((String)"force").executes(EventCommand::executeQueueSubcommand)))).then(class_2170.method_9247((String)"force").executes(EventCommand::executeQueueNoTimeoutSubcommand)));
    }

    private static LiteralArgumentBuilder<class_2168> printEvents() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"print").then(LiteralArgumentBuilder.literal((String)"registered").executes(EventCommand::executePrintRegisteredEvents))).then(LiteralArgumentBuilder.literal((String)"queued").executes(EventCommand::executePrintQueuedEvents))).then(LiteralArgumentBuilder.literal((String)"active").executes(EventCommand::executePrintActiveEvents))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"event_registry").executes(EventCommand::executePrintEventRegistriesSummary)).then(RequiredArgumentBuilder.argument((String)"registry", (ArgumentType)class_2232.method_9441()).suggests(EventCommand::getEventRegistriesSuggestions).executes(EventCommand::executePrintEventRegistryEvents)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"events_by_tag").executes(EventCommand::executePrintEventRegistriesSummary)).then(RequiredArgumentBuilder.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(EventCommand::executePrintEventsByTagInRegistry)))).then(LiteralArgumentBuilder.literal((String)"delays").executes(EventCommand::executePrintRandomEventDelays));
    }

    private static int executeStartSubcommand(CommandContext<class_2168> context) {
        class_2960 eventLoc = class_2232.method_9443(context, (String)"event");
        boolean isForced = ((ParsedCommandNode)context.getNodes().getLast()).getNode().getName().equals("force");
        boolean isDryRun = ((ParsedCommandNode)context.getNodes().getLast()).getNode().getName().equals("check");
        EventManager manager = E418.getEventManager();
        EventResource event = manager.getEvent(eventLoc);
        if (event == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.start.not_found", (Object[])new Object[]{eventLoc.toString()}).method_27692(class_124.field_1061));
            return 0;
        }
        EventContext eventContext = new EventContext(((class_2168)context.getSource()).method_9211()).withPlayer(((class_2168)context.getSource()).method_44023()).withCause(new ConsoleCommandEventCause(context)).withForced(isForced);
        if (isDryRun) {
            return EventCommand.executeStartCheck(context, event, eventContext);
        }
        ActiveEvent activeEvent = E418.getEventManager().runEvent(event, eventContext);
        if (activeEvent == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.start.fail", (Object[])new Object[]{EventCommand.formatEvent(event)}).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)("e418.commands.event.start.success" + (isForced ? ".force" : "")), (Object[])new Object[]{EventCommand.formatEvent(event)}), true);
        return 1;
    }

    private static int executeStartCheck(CommandContext<class_2168> context, EventResource eventResource, EventContext eventContext) {
        class_5250 runConditions;
        List<ICondition> run = eventResource.runConditions();
        List<ICondition> queue = eventResource.queueConditions();
        if (queue.size() == 0 && run.size() == 0) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"e418.commands.event.start.check.no_conditions").method_27692(class_124.field_1061));
            return 0;
        }
        if (run.size() > 0) {
            runConditions = class_2564.method_36332(run, (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)e.getType().toString()).method_27692(e.check(eventContext) ? class_124.field_1060 : class_124.field_1061)));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"e418.commands.event.start.check.run").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)runConditions), false);
        }
        if (queue.size() > 0) {
            runConditions = class_2564.method_36332(queue, (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)e.getType().toString()).method_27692(e.check(eventContext) ? class_124.field_1060 : class_124.field_1061)));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"e418.commands.event.start.check.queue").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)runConditions), false);
        }
        return 1;
    }

    private static int executeQueueSubcommand(CommandContext<class_2168> context) {
        class_2960 eventLoc = class_2232.method_9443(context, (String)"event");
        int timeout = IntegerArgumentType.getInteger(context, (String)"timeout");
        boolean isForced = ((ParsedCommandNode)context.getNodes().getLast()).getNode().getName().equals("force");
        EventManager manager = E418.getEventManager();
        EventResource event = manager.getEvent(eventLoc);
        if (event == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.start.not_found", (Object[])new Object[]{eventLoc.toString()}).method_27692(class_124.field_1061));
            return 0;
        }
        EventContext eventContext = new EventContext(((class_2168)context.getSource()).method_9211()).withPlayer(((class_2168)context.getSource()).method_44023()).withCause(new ConsoleCommandEventCause(context)).withForced(isForced);
        boolean isQueued = E418.getEventManager().queueEvent(event, eventContext, timeout);
        if (!isQueued) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.queue.fail", (Object[])new Object[]{EventCommand.formatEvent(event)}).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)("e418.commands.event.queue.success" + (isForced ? ".force" : "")), (Object[])new Object[]{EventCommand.formatEvent(event)}), true);
        return 1;
    }

    private static int executeQueueNoTimeoutSubcommand(CommandContext<class_2168> context) {
        class_2960 eventLoc = class_2232.method_9443(context, (String)"event");
        boolean isForced = ((ParsedCommandNode)context.getNodes().getLast()).getNode().getName().equals("force");
        EventManager manager = E418.getEventManager();
        EventResource event = manager.getEvent(eventLoc);
        if (event == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.start.not_found", (Object[])new Object[]{eventLoc.toString()}).method_27692(class_124.field_1061));
            return 0;
        }
        EventContext eventContext = new EventContext(((class_2168)context.getSource()).method_9211()).withPlayer(((class_2168)context.getSource()).method_44023()).withCause(new ConsoleCommandEventCause(context)).withForced(isForced);
        boolean isQueued = E418.getEventManager().queueEvent(event, eventContext);
        if (!isQueued) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.queue.fail", (Object[])new Object[]{EventCommand.formatEvent(event)}).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)("e418.commands.event.queue.success" + (isForced ? ".force" : "")), (Object[])new Object[]{EventCommand.formatEvent(event)}), true);
        return 1;
    }

    private static int executePrintRegisteredEvents(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print", (Object[])new Object[]{class_2564.method_36332(E418.getEventManager().getRegisteredEvents(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)(" - " + e.toString())))}), false);
        return 1;
    }

    private static int executePrintQueuedEvents(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_queued", (Object[])new Object[]{class_2564.method_36332(E418.getEventManager().getQueuedEvents(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)" - ").method_10852(EventCommand.formatEvent(e.resource())))}), false);
        return 1;
    }

    private static int executePrintActiveEvents(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_active", (Object[])new Object[]{class_2564.method_36332(E418.getEventManager().getActiveEvents(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)" - ").method_10852(EventCommand.formatEvent(e.resource)))}), false);
        return 1;
    }

    private static int executePrintEventRegistriesSummary(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_event_registries_summary", (Object[])new Object[]{class_2564.method_36332(EventRegistries.getRegistries(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43469((String)"e418.commands.event.print_event_registries_summary.line", (Object[])new Object[]{e.toString(), EventRegistries.get(e).getEvents().size()}))}), false);
        return 1;
    }

    private static int executePrintEventRegistryEvents(CommandContext<class_2168> context) {
        class_2960 registryKey = class_2232.method_9443(context, (String)"registry");
        EventRegistry registry = EventRegistries.get(registryKey);
        if (registry == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"e418.commands.event.invalid_registry", (Object[])new Object[]{registryKey.toString()}).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_event_registry", (Object[])new Object[]{class_2561.method_43470((String)registryKey.toString()), class_2564.method_36332(registry.getEvents(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43469((String)"e418.commands.event.print_event_registry.line", (Object[])new Object[]{EventCommand.formatEvent((EventResource)e.element()), e.weight()})), class_2564.method_36332(registry.getTags(), (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43470((String)" - ").method_27693(e))}), false);
        return 1;
    }

    private static int executePrintEventsByTagInRegistry(CommandContext<class_2168> context) {
        String tag = StringArgumentType.getString(context, (String)"tag");
        WeightedList<EventResource> events = EventRegistries.getEventsWithTag(tag);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_events_by_tag", (Object[])new Object[]{tag, class_2564.method_36332(events.values, (class_2561)class_2561.method_43470((String)"\n"), e -> class_2561.method_43469((String)"e418.commands.event.print_events_by_tag.line", (Object[])new Object[]{EventCommand.formatEvent((EventResource)e.element()), e.weight()}))}), false);
        return 1;
    }

    private static int executePrintRandomEventDelays(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.print_event_delays", (Object[])new Object[]{E418.getEventEngine().RandomEventManager.GlobalEventTick, class_2564.method_36332((Collection)((class_2168)context.getSource()).method_9211().method_3760().method_14571(), (class_2561)class_2561.method_43470((String)"\n"), e -> {
            PlayerData data = PlayerData.ensureData(e);
            return class_2561.method_43469((String)"e418.commands.event.print_event_delays.line", (Object[])new Object[]{e.method_55423(), data.eventTimestamp, data.eventUnlockTimestamp});
        })}), false);
        return 1;
    }

    private static int executeClear(CommandContext<class_2168> context) {
        E418.getEventManager().getQueuedEvents().forEach(event -> E418.getEventManager().dequeueEvent((QueuedEvent)event));
        E418.getEventManager().getActiveEvents().forEach(event -> E418.getEventManager().stopEvent((ActiveEvent)event));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"e418.commands.event.stop.all"), false);
        return 1;
    }

    private static int executeStopSubcommand(CommandContext<class_2168> context) {
        boolean isForced = ((ParsedCommandNode)context.getNodes().getLast()).getNode().getName().equals("dispose");
        class_2960 eventLoc = class_2232.method_9443(context, (String)"event");
        EventManager manager = E418.getEventManager();
        int count = 0;
        for (ActiveEvent d : manager.getActiveEvents()) {
            if (!eventLoc.equals((Object)manager.getResourceLocation(d))) continue;
            manager.stopEvent(d);
            if (isForced) {
                manager.disposeEvent(d);
            }
            ++count;
        }
        int finalCount = count;
        if (count > 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"e418.commands.event.stop.success", (Object[])new Object[]{finalCount}), true);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"e418.commands.event.stop.fail").method_27692(class_124.field_1061));
        }
        return count;
    }

    private static CompletableFuture<Suggestions> getActiveEventSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String input = builder.getRemaining();
        E418.getEventManager().getActiveEvents().stream().filter(e -> e.toString().startsWith(input)).forEach(e -> builder.suggest(E418.getEventManager().getResourceLocation((ActiveEvent)e).toString(), (Message)class_2561.method_43470((String)e.resource.description())));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> getEventRegistriesSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String input = builder.getRemaining();
        EventRegistries.getRegistries().stream().filter(e -> e.toString().startsWith(input)).forEach(e -> builder.suggest(e.toString()));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> getEventSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String input = builder.getRemaining();
        E418.getEventManager().getRegisteredEvents().stream().filter(e -> e.toString().startsWith(input)).forEach(e -> builder.suggest(e.toString(), (Message)class_2561.method_43470((String)E418.getEventManager().getEvent((class_2960)e).description())));
        return builder.buildFuture();
    }

    private static class_2561 formatEvent(EventResource event) {
        return class_2561.method_43470((String)event.name()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)event.description()))));
    }
}

