/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.ActiveBehaviourDispatch;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.EventResource;
import ru.maxthetomas.e418.event.IBehaviourExecutor;

public class ActiveEvent
implements IBehaviourExecutor {
    public static final MapCodec<ActiveEvent> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_2960.field_25139.xmap(v -> E418.getEventManager().getEvent((class_2960)v), res -> E418.getEventManager().getResourceLocation((EventResource)res)).fieldOf("id").forGetter(v -> v.resource), (App)EventContext.CODEC.fieldOf("context").forGetter(v -> v.context), (App)Codec.LONG.fieldOf("start_time").forGetter(v -> v.startTime), (App)ActiveBehaviourDispatch.CODEC.codec().listOf().fieldOf("active_behaviours").forGetter(v -> v.activeBehaviours.stream().map(ActiveBehaviourDispatch::create).toList())).apply((Applicative)i, ActiveEvent::createFromCodec));
    public final EventResource resource;
    public final EventContext context;
    public final long startTime;
    public final List<Behaviour> activeBehaviours = new ArrayList<Behaviour>();
    private boolean dirty = false;

    public ActiveEvent(EventResource resource, EventContext context, long startTime) {
        this.resource = resource;
        this.context = context;
        this.startTime = startTime;
    }

    public void updateState() {
        if (this.isDone()) {
            E418.getEventManager().disposeEvent(this);
        }
    }

    public void disposeBehaviours() {
        for (Behaviour activeBehaviour : this.activeBehaviours) {
            activeBehaviour.tryDispose();
        }
    }

    public void stopBehaviours() {
        for (Behaviour activeBehaviour : this.activeBehaviours) {
            activeBehaviour.tryStop();
        }
    }

    public void tick() {
        for (Behaviour activeBehaviour : this.activeBehaviours) {
            activeBehaviour.tick();
        }
    }

    public String toString() {
        return String.format("ActiveEvent[%s] (started at: %s, active behaviours: %s)", this.resource.name(), this.startTime, this.activeBehaviours.size());
    }

    @Override
    public boolean isDone() {
        for (Behaviour behaviour : this.activeBehaviours) {
            if (behaviour.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void dirty() {
        this.dirty = true;
    }

    @Override
    public void undirty() {
        this.dirty = false;
    }

    @Override
    public List<Behaviour> getExecutedBehaviours() {
        return this.activeBehaviours;
    }

    public void _restoreState() {
        this.activeBehaviours.forEach(behaviour -> {
            if (behaviour.isDisposed()) {
                return;
            }
            behaviour.restoreState(this.context, this);
        });
    }

    private static ActiveEvent createFromCodec(EventResource resource, EventContext context, long startTime, List<ActiveBehaviourDispatch<Behaviour>> activeBehaviours) {
        ActiveEvent event = new ActiveEvent(resource, context, startTime);
        event.activeBehaviours.addAll(activeBehaviours.stream().map(ActiveBehaviourDispatch::getActiveBehaviour).toList());
        event.dirty();
        return event;
    }
}

