/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.event.ActiveEvent;
import ru.maxthetomas.e418.event.cause.EventCauses;
import ru.maxthetomas.e418.event.cause.IEventCause;
import ru.maxthetomas.e418.util.Location;

public class EventContext {
    public static final MapCodec<EventContext> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.lenientOptionalFieldOf("forced", (Object)false).forGetter(v -> v.forced), (App)Location.CODEC.codec().optionalFieldOf("location").forGetter(v -> Optional.ofNullable(v.location)), (App)class_4844.field_25122.optionalFieldOf("player").forGetter(v -> Optional.ofNullable(v.player)), (App)EventCauses.DISPATCH_CODEC.fieldOf("cause").forGetter(v -> v.cause)).apply((Applicative)instance, EventContext::constructByCodec));
    private final MinecraftServer server;
    @Nullable
    private ActiveEvent sourceEvent;
    private boolean forced = false;
    @Nullable
    private Location location;
    @Nullable
    private UUID player;
    @Nullable
    private IEventCause cause;

    public EventContext(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public ActiveEvent getSourceEvent() {
        return this.sourceEvent;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    @Nullable
    public class_3222 getPlayer() {
        return E418.player(this.player);
    }

    @Nullable
    public UUID getPlayerUUID() {
        return this.player;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public boolean shouldAwaitPlayer() {
        return this.hasPlayer() && this.getPlayer() == null;
    }

    public boolean isForced() {
        return this.forced;
    }

    public IEventCause getCause() {
        return this.cause;
    }

    public EventContext withSourceEvent(ActiveEvent sourceEvent) {
        this.sourceEvent = sourceEvent;
        return this;
    }

    public EventContext withPlayer(class_3222 player) {
        this.player = player.method_5667();
        return this;
    }

    public EventContext withForced(boolean forced) {
        this.forced = forced;
        return this;
    }

    public EventContext withLocation(Location location) {
        this.location = location;
        return this;
    }

    public EventContext withCause(IEventCause cause) {
        this.cause = cause;
        return this;
    }

    public EventContext withoutPlayer() {
        this.player = null;
        return this;
    }

    public EventContext clone() {
        EventContext newContext = new EventContext(this.server);
        newContext.player = this.player;
        newContext.sourceEvent = this.sourceEvent;
        newContext.forced = this.forced;
        newContext.cause = this.cause;
        if (this.location != null) {
            newContext.location = new Location(this.location.levelId(), new class_243(this.location.position().field_1352, this.location.position().field_1351, this.location.position().field_1350));
        }
        return newContext;
    }

    private static EventContext constructByCodec(boolean forced, Optional<Location> location, Optional<UUID> player, IEventCause cause) {
        if (E418.getCurrentServer().isEmpty()) {
            throw new IllegalStateException("The current server is empty");
        }
        EventContext context = new EventContext(E418.getCurrentServer().get());
        context.cause = cause;
        context.forced = forced;
        context.location = location.orElse(null);
        context.player = player.orElse(null);
        return context;
    }
}

