/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.behaviour.Behaviour;
import ru.maxthetomas.e418.behaviour.PreActiveBehaviour;
import ru.maxthetomas.e418.event.ActiveEvent;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.EventResource;
import ru.maxthetomas.e418.event.QueuedEvent;
import ru.maxthetomas.e418.event.registry.EventRegistries;
import ru.maxthetomas.e418.event.registry.EventRegistry;
import ru.maxthetomas.e418.util.storage.InGameStorage;
import ru.maxthetomas.e418.util.storage.PlatformDataManager;

public class EventManager
extends class_4080<EventManagerData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ActiveEvent> activeEvents = new ArrayList<ActiveEvent>();
    private final List<QueuedEvent> queuedEvents = new ArrayList<QueuedEvent>();
    private Map<class_2960, EventResource> registeredEvents;
    public static boolean IsActive = false;

    public EventManager() {
        TickEvent.SERVER_POST.register(this::tick);
    }

    private void tick(MinecraftServer server) {
        if (!IsActive) {
            return;
        }
        this.updateQueuedEvents(server);
        this.updateActiveEvents();
        this.activeEvents.forEach(ActiveEvent::tick);
        InGameStorage.INSTANCE.method_80();
    }

    public void updateQueuedEvents(MinecraftServer server) {
        this.queuedEvents.removeIf(queuedEvent -> {
            if (queuedEvent.timeoutTick() != null && queuedEvent.timeoutTick() < server.method_30002().method_8510()) {
                LOGGER.info("Dequeued event {} (timed out).", (Object)queuedEvent.resource().name());
                return true;
            }
            if (queuedEvent.resource().canRun(queuedEvent.context())) {
                LOGGER.info("Running event {} from queue.", (Object)queuedEvent.resource().name());
                E418.getEventManager().runEvent(queuedEvent.resource(), queuedEvent.context());
                return true;
            }
            return false;
        });
    }

    public void updateActiveEvents() {
        this.activeEvents.removeIf(event -> {
            if (event.isDirty() && event.isDone()) {
                event.disposeBehaviours();
                LOGGER.info("Disposed event {} (Event is done)", (Object)event.resource.name());
                return true;
            }
            event.undirty();
            return false;
        });
    }

    public void fullReset(@Nullable MinecraftServer server) {
        IsActive = false;
        for (int i = 0; i < this.activeEvents.size(); ++i) {
            ActiveEvent activeEvent = this.activeEvents.get(i);
            this.disposeEvent(activeEvent);
            --i;
        }
        this.updateActiveEvents();
        if (server != null) {
            this.updateQueuedEvents(server);
            E418.getEventEngine().reset(server);
        }
        this.activeEvents.clear();
        this.queuedEvents.clear();
        PlatformDataManager.reset();
    }

    public void init() {
        IsActive = true;
    }

    public List<ActiveEvent> getActiveEvents() {
        return List.copyOf(this.activeEvents);
    }

    public List<QueuedEvent> getQueuedEvents() {
        return List.copyOf(this.queuedEvents);
    }

    @Nullable
    public EventResource getEvent(class_2960 location) {
        return this.registeredEvents.getOrDefault(location, null);
    }

    public Set<class_2960> getRegisteredEvents() {
        return this.registeredEvents.keySet();
    }

    public class_2960 getResourceLocation(ActiveEvent activeEvent) {
        return this.getResourceLocation(activeEvent.resource);
    }

    public class_2960 getResourceLocation(EventResource resource) {
        for (Map.Entry<class_2960, EventResource> entry : this.registeredEvents.entrySet()) {
            if (!entry.getValue().equals(resource)) continue;
            return entry.getKey();
        }
        return null;
    }

    public ActiveEvent runEvent(EventResource resource, EventContext context) {
        if (!resource.canRun(context)) {
            return null;
        }
        ActiveEvent activeEvent = new ActiveEvent(resource, context, context.getServer().method_30002().method_8510());
        context.withSourceEvent(activeEvent);
        this.activeEvents.add(activeEvent);
        LOGGER.info("Started event {}", (Object)resource.name());
        for (PreActiveBehaviour preActiveBehaviour : activeEvent.resource.behaviourList()) {
            Behaviour behaviour = preActiveBehaviour.create();
            behaviour.tryExecute(context, activeEvent);
            activeEvent.activeBehaviours.add(behaviour);
        }
        activeEvent.updateState();
        return activeEvent;
    }

    public boolean queueEvent(EventResource resource, EventContext context, int timeout) {
        ActiveEvent activeEvent = this.runEvent(resource, context);
        if (activeEvent != null) {
            return true;
        }
        if (!resource.canQueue(context)) {
            return false;
        }
        long timeoutTick = context.getServer().method_30002().method_8510() + (long)timeout;
        this.queuedEvents.add(new QueuedEvent(resource, context, timeoutTick));
        LOGGER.info("Queued event {}.", (Object)resource.name());
        return true;
    }

    public boolean queueEvent(EventResource resource, EventContext context) {
        ActiveEvent activeEvent = this.runEvent(resource, context);
        if (activeEvent != null) {
            return true;
        }
        if (!resource.canQueue(context)) {
            return false;
        }
        this.queuedEvents.add(new QueuedEvent(resource, context, null));
        LOGGER.info("Queued event {}.", (Object)resource.name());
        return true;
    }

    public void dequeueEvent(QueuedEvent queuedEvent) {
        LOGGER.info("Dequeued event {}", (Object)queuedEvent.resource().name());
        this.queuedEvents.remove(queuedEvent);
    }

    public void stopEvent(ActiveEvent event) {
        LOGGER.info("Stopping event {}", (Object)event.resource.name());
        event.stopBehaviours();
    }

    public void disposeEvent(ActiveEvent event) {
        LOGGER.info("Disposed event {}", (Object)event.resource.name());
        event.disposeBehaviours();
        this.activeEvents.remove(event);
    }

    public boolean isDisposed(ActiveEvent event) {
        return !this.activeEvents.contains(event);
    }

    public void _restoreActiveEvents(List<ActiveEvent> restoredActiveEvents) {
        restoredActiveEvents.forEach(e -> {
            e.context.withSourceEvent((ActiveEvent)e);
            e.updateState();
            e._restoreState();
        });
        this.activeEvents.addAll(restoredActiveEvents);
    }

    public void _restoreQueuedEvents(List<QueuedEvent> restoredQueuedEvents) {
        this.queuedEvents.addAll(restoredQueuedEvents);
    }

    @NotNull
    protected EventManagerData prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, EventResource> eventMap = new HashMap<class_2960, EventResource>();
        class_4309.method_51148((class_3300)resourceManager, (class_7654)class_7654.method_45114((String)"events"), (DynamicOps)JsonOps.INSTANCE, (Codec)EventResource.CODEC.codec(), eventMap);
        HashMap<class_2960, AddToRegistryData> addToRegistry = new HashMap<class_2960, AddToRegistryData>();
        class_4309.method_51148((class_3300)resourceManager, (class_7654)class_7654.method_45114((String)"event_registries"), (DynamicOps)JsonOps.INSTANCE, (Codec)AddToRegistryData.CODEC.codec(), addToRegistry);
        return new EventManagerData(eventMap, addToRegistry);
    }

    protected void apply(EventManagerData object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.registeredEvents = object.events();
        EventRegistries.clearAll();
        object.registryUpdate().forEach((key, value) -> {
            EventRegistry registry = EventRegistries.addRegistry(key);
            value.storedWeightedEvents().forEach(stored -> registry.addEvent(E418.getEventManager().getEvent(stored.id)));
            value.storedTags().forEach(registry::addTag);
        });
        LOGGER.info("Successfully reloaded events!");
    }

    public record AddToRegistryData(List<StoredWeightedEvent> storedWeightedEvents, List<String> storedTags) {
        public static final MapCodec<AddToRegistryData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StoredWeightedEvent.CODEC.listOf().fieldOf("events").forGetter(AddToRegistryData::storedWeightedEvents), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(AddToRegistryData::storedTags)).apply((Applicative)instance, AddToRegistryData::new));
    }

    public record EventManagerData(Map<class_2960, EventResource> events, Map<class_2960, AddToRegistryData> registryUpdate) {
    }

    public record StoredWeightedEvent(class_2960 id, int weight) {
        public static final MapCodec<StoredWeightedEvent> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(StoredWeightedEvent::id), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(StoredWeightedEvent::weight)).apply((Applicative)instance, StoredWeightedEvent::new));
        public static final Codec<StoredWeightedEvent> CODEC = Codec.withAlternative((Codec)FULL_CODEC.codec(), (Codec)class_2960.field_25139.xmap(id -> new StoredWeightedEvent((class_2960)id, 1), StoredWeightedEvent::id));

        public EventRegistry.WeightedEvent toWeightedEvent() {
            EventResource event = E418.getEventManager().getEvent(this.id);
            if (event == null) {
                LOGGER.warn("Cannot find event {}!", (Object)this.id);
                return null;
            }
            return new EventRegistry.WeightedEvent(event, this.weight);
        }
    }
}

