/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import ru.maxthetomas.e418.behaviour.PreActiveBehaviour;
import ru.maxthetomas.e418.condition.Conditions;
import ru.maxthetomas.e418.condition.ICondition;
import ru.maxthetomas.e418.event.EventContext;

public record EventResource(String name, String description, int intrusiveness, List<PreActiveBehaviour> behaviourList, List<ICondition> runConditions, List<ICondition> queueConditions) {
    public static final MapCodec<EventResource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(EventResource::name), (App)Codec.STRING.optionalFieldOf("description", (Object)"").forGetter(EventResource::description), (App)Codec.INT.optionalFieldOf("intrusiveness", (Object)0).forGetter(EventResource::intrusiveness), (App)PreActiveBehaviour.CODEC.listOf().fieldOf("behaviours").forGetter(EventResource::behaviourList), (App)Conditions.DISPATCH_CODEC.listOf().fieldOf("run_conditions").forGetter(EventResource::runConditions), (App)Conditions.DISPATCH_CODEC.listOf().fieldOf("queue_conditions").forGetter(EventResource::queueConditions)).apply((Applicative)instance, EventResource::new));

    public boolean canRun(EventContext context) {
        if (!context.isForced()) {
            for (ICondition condition : this.runConditions) {
                if (condition.check(context)) continue;
                return false;
            }
        }
        for (PreActiveBehaviour preActiveBehaviour : this.behaviourList) {
            if (preActiveBehaviour.create().canRun(context)) continue;
            return false;
        }
        return true;
    }

    public boolean canQueue(EventContext context) {
        for (ICondition condition : this.queueConditions) {
            if (condition.check(context)) continue;
            return false;
        }
        return true;
    }
}

