/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event.engine;

import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.config.Config;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.EventResource;
import ru.maxthetomas.e418.event.cause.impl.GlobalRandomEventCause;
import ru.maxthetomas.e418.event.cause.impl.PlayerRandomEventCause;
import ru.maxthetomas.e418.event.registry.EventRegistries;
import ru.maxthetomas.e418.util.E418Random;
import ru.maxthetomas.e418.util.Location;
import ru.maxthetomas.e418.util.storage.PlatformDataManager;
import ru.maxthetomas.e418.util.storage.data.PlayerData;

public class RandomEventManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public long GlobalEventTick = -1L;

    public RandomEventManager() {
        TickEvent.SERVER_POST.register(this::tick);
        LifecycleEvent.SERVER_STARTED.register(this::serverStarted);
    }

    public long getGlobalEventTick() {
        return this.GlobalEventTick;
    }

    private void serverStarted(MinecraftServer minecraftServer) {
        this.reset(minecraftServer);
    }

    public void reset(MinecraftServer srv) {
        this.GlobalEventTick = (long)Config.globalRandomEventGracePeriod.get().randomValue(E418Random.EVENT_ENGINE_GLOBAL) + srv.method_30002().method_8510();
    }

    public void tick(MinecraftServer minecraftServer) {
        long currentTime = minecraftServer.method_30002().method_8510();
        if (minecraftServer.method_3788() == 0) {
            return;
        }
        for (class_3222 player : E418.allPlayers()) {
            UUID uuid = player.method_5667();
            PlayerData data = PlayerData.ensureData(player);
            if (data.eventTimestamp >= currentTime) continue;
            class_5819 random = E418Random.EVENT_ENGINE_GLOBAL;
            Float range = Config.playerRandomEventGroupDistance.get();
            List<class_3222> playersInRange = E418.allPlayers().stream().filter(p -> p != player && p.method_37908() == player.method_37908() && player.method_19538().method_24802((class_2374)p.method_19538(), (double)range.floatValue())).toList();
            boolean hasLocks = playersInRange.stream().anyMatch(p -> {
                PlayerData playerData = PlayerData.ensureData(p);
                return playerData.eventUnlockTimestamp > currentTime;
            });
            if (hasLocks) {
                int randomDelay = random.method_43051(600, 1200);
                data.eventTimestamp = currentTime + (long)randomDelay;
                continue;
            }
            PlayerRandomEventCause cause = new PlayerRandomEventCause(uuid);
            boolean success = false;
            EventContext ctx = new EventContext(minecraftServer).withPlayer(player).withLocation(Location.fromPlayer(player)).withCause(cause);
            EventResource e = EventRegistries.getQueueableEventsWithTag("random.player", ctx, Config.baseIntrusiveness.get().floatValue()).getRandomElement(random);
            if (e != null) {
                success = E418.getEventManager().queueEvent(e, ctx);
            }
            if (success) {
                randomDelay = Config.playerRandomEventDelay.get().randomValue(random);
                int randomOffset = Config.playerRandomEventOffset.get().randomValue(random);
                int randomLock = Config.playerRandomEventLock.get().randomValue(random);
                data.eventTimestamp = currentTime + (long)randomDelay + (long)randomOffset;
                data.eventUnlockTimestamp = currentTime + (long)randomLock;
                if (!cause.isGroupEffectCancelled() && range.floatValue() > 0.0f) {
                    class_243 playerPos = player.method_19538();
                    for (class_3222 otherPlayer : playersInRange) {
                        PlayerData otherData = PlayerData.ensureData(otherPlayer);
                        class_243 otherPlayerPos = otherPlayer.method_19538();
                        double distance = playerPos.method_1022(otherPlayerPos);
                        otherData.eventTimestamp += (long)((double)randomOffset / (double)range.floatValue() * ((double)range.floatValue() - distance));
                        otherData.eventUnlockTimestamp = currentTime + (long)randomLock;
                        PlatformDataManager.storeData(PlatformDataManager.PLAYER_DATA, otherPlayer, otherData);
                    }
                }
            } else {
                randomDelay = Config.playerRandomEventDelayFailure.get().randomValue(random);
                data.eventTimestamp = currentTime + (long)randomDelay;
            }
            PlatformDataManager.storeData(PlatformDataManager.PLAYER_DATA, player, data);
        }
        if (this.GlobalEventTick <= currentTime) {
            GlobalRandomEventCause cause = new GlobalRandomEventCause();
            class_5819 random = E418Random.EVENT_ENGINE_PLAYER;
            boolean success = false;
            EventContext ctx = new EventContext(minecraftServer).withCause(cause);
            EventResource e = EventRegistries.getQueueableEventsWithTag("random.global", ctx, Config.baseIntrusiveness.get().floatValue()).getRandomElement(random);
            if (e != null) {
                success = E418.getEventManager().queueEvent(e, ctx);
            }
            this.GlobalEventTick = success ? currentTime + (long)Config.globalRandomEventDelay.get().randomValue(random) : currentTime + (long)Config.globalRandomEventDelayFailure.get().randomValue(random);
        }
    }
}

