/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.event.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import ru.maxthetomas.e418.E418;
import ru.maxthetomas.e418.event.EventContext;
import ru.maxthetomas.e418.event.EventResource;
import ru.maxthetomas.e418.event.registry.EventRegistry;
import ru.maxthetomas.e418.util.WeightedList;

public class EventRegistries {
    private static final Map<class_2960, EventRegistry> REGISTRY = new HashMap<class_2960, EventRegistry>();

    public static EventRegistry get(class_2960 id) {
        return REGISTRY.getOrDefault(id, null);
    }

    public static Set<class_2960> getRegistries() {
        return REGISTRY.keySet();
    }

    public static List<EventRegistry> getRegistriesWithTag(String tag) {
        return REGISTRY.values().stream().filter(r -> r.getTags().contains(tag)).toList();
    }

    public static WeightedList<EventResource> getEventsWithTag(String tag) {
        WeightedList<EventResource> weightedList = new WeightedList<EventResource>();
        List<EventRegistry> regs = EventRegistries.getRegistriesWithTag(tag);
        for (EventRegistry reg : regs) {
            for (WeightedList.Entry e : reg.events.values) {
                weightedList.add(e.weight(), (EventResource)e.element());
            }
        }
        return weightedList;
    }

    public static WeightedList<EventResource> getQueueableEventsWithTag(String tag, EventContext ctx, float baseIntrusiveness) {
        WeightedList<EventResource> weightedList = new WeightedList<EventResource>();
        List<EventRegistry> regs = EventRegistries.getRegistriesWithTag(tag);
        for (EventRegistry reg : regs) {
            for (WeightedList.Entry e : reg.events.values) {
                if (!((EventResource)e.element()).canQueue(ctx) || !(baseIntrusiveness >= (float)((EventResource)e.element()).intrusiveness())) continue;
                weightedList.add(e.weight(), (EventResource)e.element());
            }
        }
        return weightedList;
    }

    public static void clearAll() {
        REGISTRY.clear();
    }

    public static EventRegistry addRegistry(class_2960 location) {
        EventRegistry registry = new EventRegistry(location);
        REGISTRY.put(location, registry);
        return registry;
    }

    private static EventRegistry create(String id) {
        EventRegistry instance = new EventRegistry(E418.resLoc(id));
        REGISTRY.put(instance.getId(), instance);
        return instance;
    }
}

