/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.fabric.storage;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import ru.maxthetomas.e418.util.storage.PlatformDataType;
import ru.maxthetomas.e418.util.storage.data.IData;

public class FabricPlatformData<H extends AttachmentTarget, D extends IData<D>>
extends PlatformDataType<H, D> {
    private final AttachmentType<D> attachmentType;

    public FabricPlatformData(AttachmentType<D> attachment) {
        this.attachmentType = attachment;
    }

    @Override
    public D ensureData(H object, Supplier<D> defaultData) {
        IData attachment = (IData)object.getAttachedOrCreate(this.attachmentType, defaultData);
        return (D)attachment.duplicate();
    }

    @Override
    public D getData(H object) {
        IData attachment = (IData)object.getAttached(this.attachmentType);
        if (attachment == null) {
            return null;
        }
        return (D)attachment.duplicate();
    }

    @Override
    public void storeData(H object, D data) {
        object.setAttached(this.attachmentType, data);
    }
}

