/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import ru.maxthetomas.e418.E418;

public record Location(class_2960 levelId, class_243 position) {
    public static final MapCodec<Location> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("dimension").forGetter(v -> v.levelId), (App)class_243.field_38277.fieldOf("position").forGetter(v -> v.position)).apply((Applicative)instance, Location::fromDimensionIdAndVec3));

    public class_3218 level() {
        return E418.getCurrentServer().orElseThrow().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.levelId()));
    }

    public static Location fromPlayer(class_3222 player) {
        class_243 position = player.method_19538();
        return new Location(player.method_37908().method_27983().method_29177(), position);
    }

    public static Location fromPlayerSpawnLocation(class_3222 player) {
        if (player.method_5682() == null) {
            return null;
        }
        class_2338 respawnPosition = player.method_26280();
        class_3218 respawnLevel = player.method_5682().method_3847(player.method_26281());
        if (respawnLevel == null || respawnPosition == null) {
            return null;
        }
        return new Location(player.method_26281().method_29177(), respawnPosition.method_46558());
    }

    public static Location fromDimensionIdAndVec3(class_2960 key, class_243 position) {
        Optional<MinecraftServer> server = E418.getCurrentServer();
        if (server.isEmpty()) {
            return null;
        }
        return new Location(key, position);
    }

    public class_2338 getBlockPosition() {
        return new class_2338(new class_2382((int)Math.floor(this.position.method_10216()), (int)Math.floor(this.position.method_10214()), (int)Math.floor(this.position.method_10215())));
    }

    @Override
    public String toString() {
        return String.format("Location[level=%s, x=%.2f, y=%.2f, z=%.2f]", this.levelId, this.position.method_10216(), this.position.method_10214(), this.position.method_10215());
    }
}

