/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.util.storage;

import java.util.function.Supplier;

public abstract class PlatformDataType<O, D> {
    public abstract D ensureData(O var1, Supplier<D> var2);

    public abstract D getData(O var1);

    public abstract void storeData(O var1, D var2);

    public void reset() {
    }

    public static class NoopStorage<A, B>
    extends PlatformDataType<A, B> {
        @Override
        public B ensureData(A object, Supplier<B> defaultData) {
            throw new IllegalStateException("NoopStorage storage was not replaced in mod initialization!");
        }

        @Override
        public B getData(A object) {
            throw new IllegalStateException("NoopStorage storage was not replaced in mod initialization!");
        }

        @Override
        public void storeData(A object, B data) {
            throw new IllegalStateException("NoopStorage storage was not replaced in mod initialization!");
        }

        public static <A, B> NoopStorage<A, B> construct() {
            return new NoopStorage<A, B>();
        }
    }
}

