/*
 * Decompiled with CFR 0.152.
 */
package ru.maxthetomas.e418.util.storage.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import ru.maxthetomas.e418.config.Config;
import ru.maxthetomas.e418.util.storage.PlatformDataManager;
import ru.maxthetomas.e418.util.storage.data.IData;

public class PlayerData
implements IData<PlayerData> {
    public static Codec<PlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("event_timestamp", (Object)-1L).forGetter(v -> v.eventTimestamp), (App)Codec.LONG.optionalFieldOf("event_unlock_timestamp", (Object)0L).forGetter(v -> v.eventUnlockTimestamp)).apply((Applicative)instance, PlayerData::constructFromCodec));
    public long eventTimestamp = -1L;
    public long eventUnlockTimestamp = 0L;

    public static PlayerData constructFromCodec(long eventTimestamp, long eventUnlockTimestamp) {
        PlayerData data = new PlayerData();
        data.eventTimestamp = eventTimestamp;
        data.eventUnlockTimestamp = eventUnlockTimestamp;
        return data;
    }

    @Override
    public PlayerData duplicate() {
        PlayerData data = new PlayerData();
        data.eventTimestamp = this.eventTimestamp;
        data.eventUnlockTimestamp = this.eventUnlockTimestamp;
        return data;
    }

    public static PlayerData createPlayerData(MinecraftServer server) {
        PlayerData data = new PlayerData();
        data.eventTimestamp = server.method_30002().method_8510() + (long)Config.playerRandomEventGracePeriod.get().randomValue(class_5819.method_43047());
        return data;
    }

    public static PlayerData ensureData(class_3222 player) {
        return PlatformDataManager.ensureData(PlatformDataManager.PLAYER_DATA, player, () -> PlayerData.createPlayerData(player.method_5682()));
    }
}

