/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.fetchjs;

import com.sighs.fetchjs.Fetchjs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLPaths;

public class HttpUtil {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static boolean fetch(String url, Consumer<String> callback) {
        return HttpUtil.fetch(url, "GET", null, null, null, 20000, callback);
    }

    public static boolean fetch(String url, String method, Map<String, String> headers, String jsonBody, Map<String, String> formData, int timeoutMillis, Consumer<String> callback) {
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, executor);
        return true;
    }

    private static boolean requiresBody(String method) {
        return "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method);
    }

    private static String buildFormData(Map<String, String> formData) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : formData.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public static boolean download(String url, String path, Consumer<Double> progressCallback) {
        return HttpUtil.download(url, path, null, 20000, progressCallback);
    }

    public static boolean download(String url, String path, Map<String, String> headers, int timeoutMillis, Consumer<Double> progressCallback) {
        if (url == null || url.isEmpty() || path == null || path.isEmpty()) {
            return false;
        }
        CompletableFuture.runAsync(() -> {
            block28: {
                HttpURLConnection connection = null;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    int responseCode;
                    URL downloadUrl = new URL(url);
                    connection = (HttpURLConnection)downloadUrl.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(timeoutMillis);
                    connection.setReadTimeout(timeoutMillis);
                    if (headers != null) {
                        for (Map.Entry entry : headers.entrySet()) {
                            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    if ((responseCode = connection.getResponseCode()) >= 200 && responseCode < 300) {
                        Path filePath = FMLPaths.GAMEDIR.get().resolve(path);
                        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                        long contentLength = connection.getContentLengthLong();
                        long bytesDownloaded = 0L;
                        try {
                            int bytesRead;
                            inputStream = new BufferedInputStream(connection.getInputStream());
                            outputStream = new BufferedOutputStream(new FileOutputStream(path));
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                                bytesDownloaded += (long)bytesRead;
                                if (progressCallback == null) continue;
                                progressCallback.accept(1.0 * (double)bytesDownloaded / (double)contentLength);
                            }
                            outputStream.flush();
                            Fetchjs.LOGGER.info("File downloaded successfully: " + path);
                            break block28;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    Fetchjs.LOGGER.warn("Download failed. HTTP response: " + responseCode);
                }
                catch (Exception e) {
                    Fetchjs.LOGGER.warn("Download failed: " + e.getMessage());
                    try {
                        Files.deleteIfExists(Paths.get(path, new String[0]));
                    }
                    catch (IOException ex) {
                        Fetchjs.LOGGER.warn("Failed to delete partial download: " + ex.getMessage());
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }, executor);
        return true;
    }
}

