/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.vp.common.item;

import com.rumaruka.vp.init.VPTiers;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;

public class MagmaSwordItem
extends Item {
    private Component magma_key1 = Component.translatable((String)"vp.magma.1");
    private Component magma_key2 = Component.translatable((String)"vp.magma.2");
    private Component magma_key3 = Component.translatable((String)"vp.magma.3");

    public MagmaSwordItem(Item.Properties properties) {
        super(VPTiers.MAGMA.applySwordProperties(properties, 7.0f, 5.5f));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltip, TooltipDisplay tooltipDisplay, Consumer<Component> components, TooltipFlag flag) {
        components.accept(this.magma_key1);
        components.accept(this.magma_key2);
        components.accept(this.magma_key3);
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.setRemainingFireTicks(8);
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        BlockState blockstate2 = blockstate.getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
        if (blockstate2 == null) {
            BlockPos blockpos1 = blockpos.relative(context.getClickedFace());
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockpos1, (Direction)context.getHorizontalDirection())) {
                level.playSound((Entity)player, blockpos1, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState blockstate1 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockpos1);
                level.setBlock(blockpos1, blockstate1, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                ItemStack itemstack = context.getItemInHand();
                if (player instanceof ServerPlayer) {
                    itemstack.hurtAndBreak(3, (LivingEntity)player, context.getHand());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        level.playSound((Entity)player, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        level.setBlock(blockpos, blockstate2, 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockpos);
        if (player != null) {
            context.getItemInHand().hurtAndBreak(3, (LivingEntity)player, context.getHand());
        }
        return InteractionResult.SUCCESS;
    }
}

