/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.vp.data.wordgen.ore;

import com.rumaruka.vp.data.wordgen.ore.VPConfiguredFeatures;
import com.rumaruka.vp.data.wordgen.ore.VPOreGen;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class VPPlacedFeatures {
    public static ResourceKey<PlacedFeature> ENCHANTED_OVER_ORE = VPPlacedFeatures.createKey("enchanted_over_ore");
    public static ResourceKey<PlacedFeature> RUBY_OVER_ORE = VPPlacedFeatures.createKey("ruby_over_ore");
    public static ResourceKey<PlacedFeature> SAPPHIRE_OVER_ORE = VPPlacedFeatures.createKey("sapphire_over_ore");
    public static ResourceKey<PlacedFeature> HELLSTONE_NETHER_ORE = VPPlacedFeatures.createKey("hellstone_nether_ore");
    public static ResourceKey<PlacedFeature> MAGMA_NETHER_ORE = VPPlacedFeatures.createKey("magma_nether_ore");
    public static ResourceKey<PlacedFeature> END_ORE = VPPlacedFeatures.createKey("end_ore");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference ench = configuredFeatures.getOrThrow(VPConfiguredFeatures.ENCHANTED_ORE);
        Holder.Reference ruby = configuredFeatures.getOrThrow(VPConfiguredFeatures.RUBY_ORE);
        Holder.Reference sapphire = configuredFeatures.getOrThrow(VPConfiguredFeatures.SAPPHIRE_ORE);
        Holder.Reference magma = configuredFeatures.getOrThrow(VPConfiguredFeatures.MAGMA_ORE);
        Holder.Reference hellstone = configuredFeatures.getOrThrow(VPConfiguredFeatures.HELLFIRE_ORE);
        Holder.Reference endholder = configuredFeatures.getOrThrow(VPConfiguredFeatures.END_ORE);
        VPPlacedFeatures.register(context, ENCHANTED_OVER_ORE, ench, VPOreGen.commonOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)240))));
        VPPlacedFeatures.register(context, RUBY_OVER_ORE, ruby, VPOreGen.commonOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)240))));
        VPPlacedFeatures.register(context, SAPPHIRE_OVER_ORE, sapphire, VPOreGen.commonOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)240))));
        VPPlacedFeatures.register(context, MAGMA_NETHER_ORE, magma, VPOreGen.netherOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)200))));
        VPPlacedFeatures.register(context, HELLSTONE_NETHER_ORE, hellstone, VPOreGen.netherOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)200))));
        VPPlacedFeatures.register(context, END_ORE, endholder, VPOreGen.endOrePlacements(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)200))));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        context.register(key, (Object)new PlacedFeature(feature, placementModifiers));
    }
}

