/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.vp.init;

import java.util.EnumMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.neoforge.common.Tags;

public interface VPArmorMaterials {
    public static final ArmorMaterial OBSIDIAN = VPArmorMaterials.registerArmorMaterial("obsidian", 1000, VPArmorMaterials.createDefenseMap(2, 8, 7, 3, 9), 8, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 5.0f, 1.0f, (TagKey<Item>)Tags.Items.OBSIDIANS);
    public static final ArmorMaterial EMERALD = VPArmorMaterials.registerArmorMaterial("emerald", 50, VPArmorMaterials.createDefenseMap(2, 4, 6, 4), 13, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 8.0f, 0.3f, (TagKey<Item>)Tags.Items.GEMS_EMERALD);
    public static final ArmorMaterial ENDER = VPArmorMaterials.registerArmorMaterial("ender", 50, VPArmorMaterials.createDefenseMap(2, 6, 6, 4), 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 8.0f, 0.4f, (TagKey<Item>)Tags.Items.GEMS_EMERALD);
    public static final ArmorMaterial WATER = VPArmorMaterials.registerArmorMaterial("water", 30, VPArmorMaterials.createDefenseMap(2, 5, 6, 2), 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 5.0f, 0.5f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)"water")));
    public static final ArmorMaterial SCORCHED = VPArmorMaterials.registerArmorMaterial("scorched", 25, VPArmorMaterials.createDefenseMap(2, 4, 5, 3), 12, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 4.0f, 0.3f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)"scorched")));
    public static final ArmorMaterial RUBY = VPArmorMaterials.registerArmorMaterial("ruby", 20, VPArmorMaterials.createDefenseMap(2, 5, 7, 2), 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 6.0f, 0.5f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)"ruby")));
    public static final ArmorMaterial SAPPHIRE = VPArmorMaterials.registerArmorMaterial("sapphire", 20, VPArmorMaterials.createDefenseMap(2, 5, 7, 2), 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 6.0f, 0.5f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)"sapphire")));
    public static final ArmorMaterial GUARDIAN = VPArmorMaterials.registerArmorMaterial("guardian", 40, VPArmorMaterials.createDefenseMap(3, 6, 5, 3), 6, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 7.0f, 0.9f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)"guardian")));

    public static ResourceKey<EquipmentAsset> createId(String name) {
        return ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)name));
    }

    public static EnumMap<ArmorType, Integer> createDefenseMap(int boots, int leggings, int chestplate, int helmet, int body) {
        EnumMap<ArmorType, Integer> defenseMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
        defenseMap.put(ArmorType.BOOTS, boots);
        defenseMap.put(ArmorType.LEGGINGS, leggings);
        defenseMap.put(ArmorType.CHESTPLATE, chestplate);
        defenseMap.put(ArmorType.HELMET, helmet);
        defenseMap.put(ArmorType.BODY, body);
        return defenseMap;
    }

    public static EnumMap<ArmorType, Integer> createDefenseMap(int boots, int leggings, int chestplate, int helmet) {
        EnumMap<ArmorType, Integer> defenseMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
        defenseMap.put(ArmorType.BOOTS, boots);
        defenseMap.put(ArmorType.LEGGINGS, leggings);
        defenseMap.put(ArmorType.CHESTPLATE, chestplate);
        defenseMap.put(ArmorType.HELMET, helmet);
        return defenseMap;
    }

    private static ArmorMaterial registerArmorMaterial(String name, int durability, EnumMap<ArmorType, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient) {
        return VPArmorMaterials.createArmorMaterial(durability, defenseMap, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, VPArmorMaterials.createId(name));
    }

    private static ArmorMaterial createArmorMaterial(int durability, EnumMap<ArmorType, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceKey<EquipmentAsset> assetKey) {
        EnumMap<ArmorType, Integer> mappedDefense = new EnumMap<ArmorType, Integer>(ArmorType.class);
        for (ArmorType type : ArmorType.values()) {
            mappedDefense.put(type, defenseMap.get(type));
        }
        return new ArmorMaterial(durability, mappedDefense, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, assetKey);
    }
}

