/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.vp.data.wordgen.ore;

import com.rumaruka.vp.common.block.BlockEnchantedOre;
import com.rumaruka.vp.common.block.BlockEnderCrystalOre;
import com.rumaruka.vp.common.block.BlockHellFireOre;
import com.rumaruka.vp.common.block.BlockMagmaOre;
import com.rumaruka.vp.common.block.BlockRubyOre;
import com.rumaruka.vp.common.block.BlockSaphhireOre;
import com.rumaruka.vp.init.VPBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.Tags;

public class VPConfiguredFeatures {
    protected static ResourceKey<ConfiguredFeature<?, ?>> ENCHANTED_ORE = VPConfiguredFeatures.createKey("enchanted_ore");
    protected static ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE = VPConfiguredFeatures.createKey("sapphire_ore");
    protected static ResourceKey<ConfiguredFeature<?, ?>> RUBY_ORE = VPConfiguredFeatures.createKey("ruby_ore");
    protected static ResourceKey<ConfiguredFeature<?, ?>> MAGMA_ORE = VPConfiguredFeatures.createKey("magma_ore");
    protected static ResourceKey<ConfiguredFeature<?, ?>> HELLFIRE_ORE = VPConfiguredFeatures.createKey("hellfire_ore");
    protected static ResourceKey<ConfiguredFeature<?, ?>> END_ORE = VPConfiguredFeatures.createKey("end_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplacable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest netherReplacable = new TagMatchTest(Tags.Blocks.NETHERRACKS);
        TagMatchTest endReplacable = new TagMatchTest(Tags.Blocks.END_STONES);
        List<OreConfiguration.TargetBlockState> enchantedOre = List.of(OreConfiguration.target((RuleTest)stoneReplacable, (BlockState)((BlockEnchantedOre)((Object)VPBlocks.ENCHANTED_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> rubyOre = List.of(OreConfiguration.target((RuleTest)stoneReplacable, (BlockState)((BlockRubyOre)((Object)VPBlocks.RUBY_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> sapphireOre = List.of(OreConfiguration.target((RuleTest)stoneReplacable, (BlockState)((BlockSaphhireOre)((Object)VPBlocks.SAPPHIRE_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> hellfireOre = List.of(OreConfiguration.target((RuleTest)netherReplacable, (BlockState)((BlockHellFireOre)((Object)VPBlocks.HELLFIRE_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> magmaOre = List.of(OreConfiguration.target((RuleTest)netherReplacable, (BlockState)((BlockMagmaOre)((Object)VPBlocks.MAGMA_ORE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> endOre = List.of(OreConfiguration.target((RuleTest)endReplacable, (BlockState)((BlockEnderCrystalOre)((Object)VPBlocks.ENDER_CRYSTAL_ORE.get())).defaultBlockState()));
        VPConfiguredFeatures.register(context, ENCHANTED_ORE, Feature.ORE, new OreConfiguration(enchantedOre, 4));
        VPConfiguredFeatures.register(context, RUBY_ORE, Feature.ORE, new OreConfiguration(rubyOre, 4));
        VPConfiguredFeatures.register(context, SAPPHIRE_ORE, Feature.ORE, new OreConfiguration(sapphireOre, 4));
        VPConfiguredFeatures.register(context, HELLFIRE_ORE, Feature.ORE, new OreConfiguration(hellfireOre, 4));
        VPConfiguredFeatures.register(context, MAGMA_ORE, Feature.ORE, new OreConfiguration(magmaOre, 4));
        VPConfiguredFeatures.register(context, END_ORE, Feature.ORE, new OreConfiguration(endOre, 4));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vp", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }
}

