/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.illagerexpansion.world.features.structurefeatures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.illagerexpansion.world.features.StructureRegistry;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5434;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7057;
import net.minecraft.class_7151;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class BaseStructure
extends class_3195 {
    public static final MapCodec<BaseStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BaseStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, BaseStructure::new)).flatXmap(BaseStructure.createValidator(), BaseStructure.createValidator());
    protected final class_6880<class_3785> startPool;
    protected final Optional<class_2960> startJigsawName;
    protected final int size;
    protected final class_6122 startHeight;
    protected final Optional<class_2902.class_2903> projectStartToHeightmap;
    protected final int maxDistanceFromCenter;

    public BaseStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public BaseStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, class_6122 startHeight, class_2902.class_2903 projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, startHeight, Optional.of(projectStartToHeightmap), 80);
    }

    public BaseStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, class_6122 startHeight) {
        this(config, startPool, Optional.empty(), size, startHeight, Optional.empty(), 80);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!this.canGenerate(context)) {
            return Optional.empty();
        }
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)false, this.projectStartToHeightmap, (class_5434.class_11600)new class_5434.class_11600(this.maxDistanceFromCenter), (class_8891)class_8891.field_46826, (class_9778)class_9778.field_51953, (class_9822)class_9822.field_52238);
    }

    public class_7151<?> method_41618() {
        return StructureRegistry.BASE_STRUCTURE;
    }

    public boolean canGenerate(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = chunkPos.field_9181 >> 4;
        int j = chunkPos.field_9180 >> 4;
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_43052((long)(i ^ j << 4) ^ context.comp_567());
        chunkRandom.method_43054();
        if (chunkRandom.method_43048(5) != 0) {
            return false;
        }
        return !context.comp_562().method_46696((class_7225)context.comp_561().method_30530(class_7924.field_41248), context.comp_564(), context.comp_567()).method_46709((class_6880)context.comp_561().method_30530(class_7924.field_41248).method_46747(class_7057.field_37146), chunkPos.field_9181, chunkPos.field_9180, 10);
    }

    private static Function<BaseStructure, DataResult<BaseStructure>> createValidator() {
        return feature -> {
            int i = switch (feature.method_42701()) {
                case class_5847.field_28922 -> 0;
                case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432 -> 12;
                default -> throw new IncompatibleClassChangeError();
            };
            return feature.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)feature);
        };
    }
}

