/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.extragems.items;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import xxrexraptorxx.extragems.utils.Config;
import xxrexraptorxx.extragems.utils.GemHelper;

public class ItemAmulet
extends Item {
    public ItemAmulet(Item.Properties properties) {
        super(properties.stacksTo(1).durability(100).rarity(Rarity.RARE));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemInHand();
        Player player = event.getPlayer();
        level.playSound((Entity)player, player.position().x, player.position().y, player.position().z, SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown(stack, ((Integer)Config.AMULET_EFFECT_COOLDOWN.get()).intValue());
        if (((Boolean)Config.AMULET_DESTROYABLE.get()).booleanValue()) {
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                stack.shrink(1);
            }
        }
        if (!level.isClientSide()) {
            AreaEffectCloud cloud = new AreaEffectCloud(level, player.position().x, player.position().y + 0.5, player.position().z);
            cloud.setDuration(5);
            cloud.setRadius((float)((Integer)Config.AMULET_EFFECT_RADIUS.get()).intValue());
            cloud.setWaitTime(1);
            cloud.setCustomParticle((ParticleOptions)ParticleTypes.CRIT);
            cloud.addEffect(new MobEffectInstance(GemHelper.getEffect(BuiltInRegistries.ITEM.getKey((Object)this).toString()), ((Integer)Config.AMULET_EFFECT_DURATION.get()).intValue(), ((Integer)Config.AMULET_EFFECT_AMPLIFIER.get()).intValue()));
            level.addFreshEntity((Entity)cloud);
        }
        return InteractionResult.SUCCESS;
    }
}

