/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.extragems.registry;

import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public class ModTrimMaterials {
    public static final ResourceKey<TrimMaterial> RUBY = ModTrimMaterials.registerKey("ruby");
    public static final ResourceKey<TrimMaterial> SAPPHIRE = ModTrimMaterials.registerKey("sapphire");
    public static final ResourceKey<TrimMaterial> TOPAZ = ModTrimMaterials.registerKey("topaz");
    public static final ResourceKey<TrimMaterial> AMETHYST = ModTrimMaterials.registerKey("amethyst");
    public static final ResourceKey<TrimMaterial> CRYSTAL = ModTrimMaterials.registerKey("crystal");
    public static final MaterialAssetGroup RUBY_ASSET_GROUP = MaterialAssetGroup.create((String)"ruby");
    public static final MaterialAssetGroup SAPPHIRE_ASSET_GROUP = MaterialAssetGroup.create((String)"sapphire");
    public static final MaterialAssetGroup TOPAZ_ASSET_GROUP = MaterialAssetGroup.create((String)"topaz");
    public static final MaterialAssetGroup AMETHYST_ASSET_GROUP = MaterialAssetGroup.create((String)"amethyst");
    public static final MaterialAssetGroup CRYSTAL_ASSET_GROUP = MaterialAssetGroup.create((String)"crystal");

    private static ResourceKey<TrimMaterial> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extragems", (String)name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        ModTrimMaterials.register(context, RUBY, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#d11313").getOrThrow()), RUBY_ASSET_GROUP);
        ModTrimMaterials.register(context, SAPPHIRE, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#003891").getOrThrow()), SAPPHIRE_ASSET_GROUP);
        ModTrimMaterials.register(context, TOPAZ, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#031cfc").getOrThrow()), TOPAZ_ASSET_GROUP);
        ModTrimMaterials.register(context, CRYSTAL, Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#8fd9db").getOrThrow()), CRYSTAL_ASSET_GROUP);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> resourceKey, Style style, MaterialAssetGroup group) {
        MutableComponent component = Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)resourceKey.location())).withStyle(style);
        context.register(resourceKey, (Object)new TrimMaterial(group, (Component)component));
    }
}

