package com.github.wyzzard225.unbreakable_leads.mixin;

import net.minecraft.class_9817;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_9817.class)
interface LeashFixMixin {

	 @Inject(method = "getLeashSnappingDistance", at = @At("HEAD"), cancellable = true)
	 private void overrideLeashSnappingDistance(CallbackInfoReturnable<Double> cir) {
			// Return a very large number to prevent leash snapping
			cir.setReturnValue(Double.MAX_VALUE);
	 }

	 @Inject(method = "snapLongLeash", at = @At("HEAD"), cancellable = true)
	 private void cancelSnapLongLeash(CallbackInfo ci) {
			// Cancel the leash snapping (breaking)
			ci.cancel();
	 }

	 @Inject(method = "detachLeash()V", at = @At("HEAD"), cancellable = true)
	 private void cancelDetachLeash(CallbackInfo ci) {
			// Cancel leash detaching
			ci.cancel();
	 }
}