/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.wrenchest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="wrenchest")
@EventBusSubscriber
public class Wrenchest {
    public static final String MODID = "wrenchest";
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"wrenchest");
    public static final DeferredItem<Item> CHEST_WRENCH = ITEMS.registerItem("chest_wrench", p -> new Item((Item.Properties)p){

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
            InteractionResult result = this.checkConnections(ctx);
            if (result == InteractionResult.SUCCESS && !ctx.getPlayer().isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), ctx.getHand().asEquipmentSlot());
            }
            return result;
        }

        private InteractionResult checkConnections(UseOnContext ctx) {
            BlockPos otherPos;
            BlockState otherState;
            BlockPos pos;
            if (!(ctx.getLevel().getBlockState(ctx.getClickedPos()).getBlock() instanceof ChestBlock)) {
                return InteractionResult.PASS;
            }
            Level level = ctx.getLevel();
            BlockState chestState = level.getBlockState(pos = ctx.getClickedPos());
            if (chestState.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                Direction facingTowardsOther = ChestBlock.getConnectedDirection((BlockState)chestState);
                level.setBlockAndUpdate(pos, (BlockState)chestState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE));
                level.setBlockAndUpdate(pos.relative(facingTowardsOther), (BlockState)level.getBlockState(pos.relative(facingTowardsOther)).setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE));
                return InteractionResult.SUCCESS;
            }
            if (ctx.getClickedFace() != Direction.UP && ctx.getClickedFace() != Direction.DOWN && (otherState = level.getBlockState(otherPos = pos.relative(ctx.getClickedFace()))).getBlock() instanceof ChestBlock && otherState.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE) {
                if (chestState.getBlock() != otherState.getBlock()) {
                    return InteractionResult.PASS;
                }
                Direction facing = (Direction)chestState.getValue((Property)ChestBlock.FACING);
                Direction otherFacing = (Direction)otherState.getValue((Property)ChestBlock.FACING);
                if ((ctx.getClickedFace() == facing || ctx.getClickedFace() == otherFacing) && facing.getOpposite() == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.getClickedFace(), facing, Mth.frac((double)ctx.getClickLocation().x), Mth.frac((double)ctx.getClickLocation().z), true)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (ctx.getClickedFace().getClockWise() == facing || ctx.getClickedFace().getCounterClockWise() == facing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.getClickedFace(), facing, Mth.frac((double)ctx.getClickLocation().x), Mth.frac((double)ctx.getClickLocation().z), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (ctx.getClickedFace().getClockWise() == otherFacing || ctx.getClickedFace().getCounterClockWise() == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.getClickedFace(), otherFacing, Mth.frac((double)ctx.getClickLocation().x), Mth.frac((double)ctx.getClickLocation().z), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (facing == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.getClickedFace(), facing.getClockWise(), Mth.frac((double)ctx.getClickLocation().x), Mth.frac((double)ctx.getClickLocation().z), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        }

        private boolean connectChests(Level level, BlockPos clickedPos, BlockPos otherPos, BlockState clickedState, BlockState otherState, Direction clickedFace, Direction chestFacing, double hitX, double hitZ, boolean swapDirections) {
            Direction newFacing = Direction.UP;
            if (!swapDirections) {
                if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                    newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                    newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                }
            } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
            } else if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                Direction direction = newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
            }
            if (newFacing != Direction.UP) {
                ChestType newType = this.getNewChestType(clickedFace, newFacing);
                level.setBlockAndUpdate(clickedPos, (BlockState)((BlockState)clickedState.setValue((Property)ChestBlock.FACING, (Comparable)newFacing)).setValue((Property)ChestBlock.TYPE, (Comparable)newType));
                level.setBlockAndUpdate(otherPos, (BlockState)((BlockState)otherState.setValue((Property)ChestBlock.FACING, (Comparable)newFacing)).setValue((Property)ChestBlock.TYPE, (Comparable)newType.getOpposite()));
                return true;
            }
            return false;
        }

        private ChestType getNewChestType(Direction clickedFace, Direction chestFacing) {
            return switch (chestFacing) {
                case Direction.NORTH -> {
                    if (clickedFace == Direction.WEST) {
                        yield ChestType.RIGHT;
                    }
                    yield ChestType.LEFT;
                }
                case Direction.SOUTH -> {
                    if (clickedFace == Direction.WEST) {
                        yield ChestType.LEFT;
                    }
                    yield ChestType.RIGHT;
                }
                case Direction.EAST -> {
                    if (clickedFace == Direction.NORTH) {
                        yield ChestType.RIGHT;
                    }
                    yield ChestType.LEFT;
                }
                case Direction.WEST -> {
                    if (clickedFace == Direction.NORTH) {
                        yield ChestType.LEFT;
                    }
                    yield ChestType.RIGHT;
                }
                default -> ChestType.SINGLE;
            };
        }
    }, new Item.Properties().durability(256).repairable(Items.IRON_INGOT));

    public Wrenchest(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.insertBefore(new ItemStack((ItemLike)Items.FISHING_ROD), new ItemStack((ItemLike)CHEST_WRENCH.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

