/*
 * Decompiled with CFR 0.152.
 */
package chadlymasterson.playerxp;

import chadlymasterson.playerxp.Config;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.reactive.ObservableSubscription;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="playerxp")
public class PlayerXp {
    public static final String MOD_ID = "playerxp";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"playerxp");
    public static Config config;
    ObservableSubscription<PokemonCapturedEvent> captureEvent = CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOW, event -> {
        ServerPlayer player = event.getPlayer();
        int pkmnLvl = event.getPokemon().getLevel();
        this.handleXP(player, pkmnLvl);
    });
    ObservableSubscription<BattleVictoryEvent> subscription = CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.LOW, event -> {
        List winners = event.getWinners();
        List losers = event.getLosers();
        int loserLevel = 0;
        for (BattleActor actor : losers) {
            if (!(actor instanceof PokemonBattleActor)) continue;
            PokemonBattleActor battleActor = (PokemonBattleActor)actor;
            Pokemon pkmn = battleActor.getPokemon().getOriginalPokemon();
            loserLevel += pkmn.getLevel();
        }
        for (BattleActor actor : winners) {
            if (!(actor instanceof PlayerBattleActor)) continue;
            PlayerBattleActor player = (PlayerBattleActor)actor;
            this.handleXP(player.getEntity(), loserLevel);
        }
        return null;
    });

    public PlayerXp() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        config = PlayerXp.getConfig();
    }

    private void handleXP(ServerPlayer player, int level) {
        if (!config.shouldGiveLevels()) {
            int xp = config.getBaseXP() * (float)level < 1.0f ? 1 : (int)Math.floor(config.getBaseXP() * (float)level);
            player.giveExperiencePoints(xp);
        } else {
            int levels = config.getBaseLevels() * level;
            player.giveExperienceLevels(levels);
        }
    }

    public static Config getConfig() {
        if (config == null) {
            config = new Config("playerxp.json");
            config.load();
        }
        return config;
    }
}

